/*!\file SurfaceAreax
 * \brief: compute Surface area
 */

#include "./SurfaceAreax.h"

#include "../../shared/shared.h"
#include "../../toolkits/toolkits.h"
#include "../InputUpdateFromConstantx/InputUpdateFromConstantx.h"

void SurfaceAreax( IssmDouble* pS, Elements* elements,Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials,Parameters* parameters){

	/*Intermediary*/
	Element* element=NULL;
	int i;

	/*output: */
	IssmDouble S=0;
	IssmDouble S_sum;

	/*Compute gradients: */
	for (i=0;i<elements->Size();i++){
		element=dynamic_cast<Element*>(elements->GetObjectByOffset(i));
		S+=element->SurfaceArea();
	}

	/*Sum all J from all cpus of the cluster:*/
 	ISSM_MPI_Reduce (&S,&S_sum,1,ISSM_MPI_DOUBLE,ISSM_MPI_SUM,0,IssmComm::GetComm() );
	ISSM_MPI_Bcast(&S_sum,1,ISSM_MPI_DOUBLE,0,IssmComm::GetComm()); 
	S=S_sum;

	/*add surface area to element inputs:*/
	InputUpdateFromConstantx(elements,nodes,vertices,loads,materials,parameters,S,SurfaceAreaEnum);

	/*Assign output pointers: */
	if(pS) *pS=S;
}
