/*!\file:  ThermalIsPresent.cpp
 * \brief
 */ 

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "./ConstraintsStateLocal.h"

int ThermalIsPresent(Loads* loads,int configuration_type){

	int i;
	int found=0;
	int mpi_found=0;

	for(i=0;i<loads->Size();i++){
		Object* object=(Object*)loads->GetObjectByOffset(i);
		Load* load=(Load*)object;
		if(load->InAnalysis(configuration_type)){
			if (object->ObjectEnum()==PengridEnum){
				found=1;
				break;
			}
		}
	}

	ISSM_MPI_Reduce (&found,&mpi_found,1,ISSM_MPI_INT,ISSM_MPI_SUM,0,IssmComm::GetComm() );
	ISSM_MPI_Bcast(&mpi_found,1,ISSM_MPI_INT,0,IssmComm::GetComm());                
	found=mpi_found;

	return found;
}
