/*!\file:  PentaRef.h
 * \brief abstract class for handling Penta oriented routines, like nodal functions, 
 * strain rate generation, etc ...
 */ 

#ifndef _PENTAREF_H_
#define _PENTAREF_H_

class GaussPenta;
class PentaRef{

	public: 
		int* element_type_list; //P1CG, P1DG, MINI, P2...
		int  element_type;

		PentaRef();
		PentaRef(const int nummodels);
		~PentaRef();

		/*Management*/
		void SetElementType(int type,int type_counter);

		/*Numerics*/
		void GetNodalFunctions(IssmDouble* basis, GaussPenta* gauss);
		void GetNodalFunctionsVelocity(IssmDouble* basis, GaussPenta* gauss);
		void GetNodalFunctionsPressure(IssmDouble* basis, GaussPenta* gauss);
		void GetNodalFunctionsDerivatives(IssmDouble* dbasis,IssmDouble* xyz_list,GaussPenta* gauss);
		void GetNodalFunctionsDerivativesVelocity(IssmDouble* dbasis,IssmDouble* xyz_list,GaussPenta* gauss);
		void GetNodalFunctionsDerivativesPressure(IssmDouble* dbasis,IssmDouble* xyz_list,GaussPenta* gauss);
		void GetNodalFunctionsDerivativesReference(IssmDouble* dbasis,GaussPenta* gauss);
		void GetNodalFunctionsP1(IssmDouble* l1l6, GaussPenta* gauss);
		void GetNodalFunctionsMINI(IssmDouble* l1l7, GaussPenta* gauss);
		void GetNodalFunctionsP1Derivatives(IssmDouble* dh1dh6,IssmDouble* xyz_list, GaussPenta* gauss);
		void GetNodalFunctionsMINIDerivatives(IssmDouble* dh1dh7,IssmDouble* xyz_list, GaussPenta* gauss);
		void GetNodalFunctionsP1DerivativesReference(IssmDouble* dl1dl6,GaussPenta* gauss);
		void GetNodalFunctionsMINIDerivativesReference(IssmDouble* dl1dl7,GaussPenta* gauss);
		void GetQuadNodalFunctions(IssmDouble* l1l4,GaussPenta* gauss,int index1,int index2,int index3,int index4);
		void GetQuadJacobianDeterminant(IssmDouble*  Jdet, IssmDouble xyz_list[4][3],GaussPenta* gauss);
		void GetJacobian(IssmDouble* J, IssmDouble* xyz_list,GaussPenta* gauss);
		void GetJacobianDeterminant(IssmDouble*  Jdet, IssmDouble* xyz_list,GaussPenta* gauss);
		void GetTriaJacobianDeterminant(IssmDouble*  Jdet, IssmDouble* xyz_list,GaussPenta* gauss);
		void GetSegmentJacobianDeterminant(IssmDouble*  Jdet, IssmDouble* xyz_list,GaussPenta* gauss);
		void GetJacobianInvert(IssmDouble*  Jinv, IssmDouble* xyz_list,GaussPenta* gauss);
		void GetBSSAHO(IssmDouble* B, IssmDouble* xyz_list, GaussPenta* gauss);
		void GetBSSAFS(IssmDouble* B, IssmDouble* xyz_list, GaussPenta* gauss);
		void GetBHO(IssmDouble* B, IssmDouble* xyz_list, GaussPenta* gauss);
		void GetBFSstrainrate(IssmDouble* B, IssmDouble* xyz_list, GaussPenta* gauss);
		void GetBFS(IssmDouble* B, IssmDouble* xyz_list, GaussPenta* gauss);
		void GetBFSGLS(IssmDouble* B, IssmDouble* xyz_list, GaussPenta* gauss);
		void GetBprimeSSAFS(IssmDouble* Bprime, IssmDouble* xyz_list, GaussPenta* gauss);
		void GetBprimeHO(IssmDouble* B, IssmDouble* xyz_list, GaussPenta* gauss);
		void GetBprimeFS(IssmDouble* B_prime, IssmDouble* xyz_list, GaussPenta* gauss);
		void GetBprimeFSGLS(IssmDouble* B_prime, IssmDouble* xyz_list, GaussPenta* gauss);
		void GetBprimeVert(IssmDouble* B, IssmDouble* xyz_list, GaussPenta* gauss);
		void GetBAdvec(IssmDouble* B_advec, IssmDouble* xyz_list, GaussPenta* gauss);
		void GetBConduct(IssmDouble* B_conduct, IssmDouble* xyz_list, GaussPenta* gauss);
		void GetBVert(IssmDouble* B, IssmDouble* xyz_list, GaussPenta* gauss);
		void GetBprimeAdvec(IssmDouble* Bprime_advec, IssmDouble* xyz_list, GaussPenta* gauss);
		void GetBHOFriction(IssmDouble* L, GaussPenta* gauss);
		void GetLFS(IssmDouble* LFS, GaussPenta* gauss);
		void GetLprimeFS(IssmDouble* LprimeFS, IssmDouble* xyz_list, GaussPenta* gauss);
		void GetLSSAFS(IssmDouble* LSSAFS, GaussPenta* gauss);
		void GetLprimeSSAFS(IssmDouble* LprimeSSAFS, IssmDouble* xyz_list, GaussPenta* gauss);
		void GetLFSSSA(IssmDouble* LFSSSA, GaussPenta* gauss);
		void GetLprimeFSSSA(IssmDouble* LprimeFSSSA, IssmDouble* xyz_list, GaussPenta* gauss);
		void GetInputValue(IssmDouble* pvalue,IssmDouble* plist, GaussPenta* gauss);
		void GetInputValue(IssmDouble* pvalue,IssmDouble* plist,GaussTria* gauss){_error_("only PentaGauss are supported");};
		void GetInputDerivativeValue(IssmDouble* pvalues, IssmDouble* plist,IssmDouble* xyz_list, GaussPenta* gauss);
		void GetInputDerivativeValue(IssmDouble* pvalues, IssmDouble* plist,IssmDouble* xyz_list, GaussTria* gauss){_error_("only PentaGauss are supported");};

		void BasalNodeIndices(int* pnumindices,int** pindices,int finiteelement);
		int  NumberofNodes(void);
		int  NumberofNodesVelocity(void);
		int  NumberofNodesPressure(void);
		int  VelocityInterpolation(void);
		int  PressureInterpolation(void);
};
#endif
