import numpy
from model import *
from triangle import *
from meshprocessrifts import *
from setmask import *
from parameterize import *
from matdamageice import *
from paterson import *
from setflowequation import *
from EnumDefinitions import *
from solve import *
from MatlabFuncs import *

md=triangle(model(),'../Exp/SquareHole.exp','../Exp/Rifts.exp',50000.)
md=meshprocessrifts(md,'../Exp/Square.exp')
md=setmask(md,'all','')
md=parameterize(md,'../Par/SquareShelf2.py')
md.materials=matdamageice()
md.materials.rheology_B=paterson(md.initialization.temperature)
md.materials.rheology_n=3.*numpy.ones((md.mesh.numberofelements,1))
md.materials.rheology_Z=0.5*numpy.ones((md.mesh.numberofvertices,1))
md=setflowequation(md,'SSA','all')

md.cluster=generic('name',oshostname(),'np',3)
md=solve(md,StressbalanceSolutionEnum())

#Fields and tolerances to track changes
field_names     =['Vx','Vy','Vel','Pressure']
field_tolerances=[1e-11,1e-11,1e-11,1e-11]
field_values=[\
	   md.results.StressbalanceSolution.Vx,\
	   md.results.StressbalanceSolution.Vy,\
	   md.results.StressbalanceSolution.Vel,\
	   md.results.StressbalanceSolution.Pressure,\
	   ]
