#!/bin/bash
#generate html report from nightly.log output file

#Process log
cat nightly.log | grep 'package: macayeal'      | grep -v "not supported yet" > macayeal.log
cat nightly.log | grep 'package: ice'           | grep -v "not supported yet" > ice.log
cat nightly.log | grep 'package: cielo_serial'  | grep -v "not supported yet" > cielo_serial.log
cat nightly.log | grep 'package: cielo_parallel'| grep -v "not supported yet" > cielo_parallel.log
cat nightly.log | grep NIGHTLYRUNTERMINATEDCORRECTLY > check.log
cat nightly.log | grep ERROR | grep -v "PETSC ERROR" > errors.log
cat nightly.log | grep SUCCESS > success.log
cat errors.log success.log > tests.log

#create some variables
if [ `wc -l nightly.log | awk '{printf("%s",$1);}'`  = "0" ]
then
	IS_INSTALL=0
else
	IS_INSTALL=1
fi
if [ `wc -l check.log | awk '{printf("%s",$1);}'`  = "0" ]
then
	IS_END=0
else
	IS_END=1
fi

#build report.html

#first: header
cat << END > header.html
<html>
<title>ISSM - Nightly run Report</title>
<body>

<style type="text/css">
	<!--
	.issmbody {
		margin: auto;
		width:800px;
		background: none;
		color: #404040;
		font-family: Arial, Verdana, Tahoma;
		font-size: 14px;
		font-weight: normal;
		text-align: left;
		}

	.issmh1 {
		margin:2em auto;
		width:800px;
		background: none;
		color: #6495ed;
		font-family: Arial, Verdana, Tahoma;
		font-size: 35px;
		font-weight: bold;
		text-align: center;
		}

	.issmh2 {
		margin:1.5em auto 1em auto;
		width:800px;
		background: transparent;
		color: #6495ed;
		font-family: Arial, Verdana, Tahoma;
		font-weight: bold;
		font-size: 28px;
		text-align: left;
		}

	.issmfooter {
		margin:auto;
		width:800px;
		background: none;
		color: #404040;
		font-family: Arial, Verdana, Tahoma;
		font-size: 12px;
		font-weight: normal;
		text-align: center;
		}

	.issmcomment {
		padding:4px;
		margin:0 auto;
		width:800px;
		border:1px dashed #000000;
		text-align: left;
		font-family: Arial, Verdana, Tahoma;
		font-size: 14px;
		color: #404040;
		background-color:#ffffdd}
	-->
</style>
<div class="issmh1">ISSM Nightly run report</div>
<br>
END

#then: summary
cat << END > summary.html
<div class="issmcomment">
date: $TODAY<br>
host: $HOST_NAME<br>
OS:   $OS<br>
release: $ISSM_RELEASE<br>
total elapsed time: $ELAPSED_TOTAL<br>
installation elapsed time: $ELAPSED_INSTAL<br>
runs elapsed time: $ELAPSED_RUN<br>
<br>
status: $(if [ $(echo $IS_INSTALL) = 0 ];
then
	#installation failed, end of report
	echo "<span style=\"color:#FF0000\">installation failed</span></div>"
	rm check.log errors.log success.log tests.log
else
	if [ $(echo $IS_END) = 0 ];
	then
		echo "<span style=\"color:#FF0000\">stopped before the end</span>"
	else
		echo "all test desks have been run"
	fi
	echo "<br>"
	echo "number of errors: $(wc -l errors.log | awk '{printf("%s",$1);}')/$(wc -l tests.log | awk '{printf("%s",$1);}';  rm errors.log)<br>"
	echo "number of success: $(wc -l success.log | awk '{printf("%s",$1);}')/$(wc -l tests.log | awk '{printf("%s",$1);}';rm success.log tests.log)</div>"
	echo "<br>"
	echo "<hr width=\"900px\">"
	rm check.log
fi) 
END

#report content
if [ $(echo $IS_INSTALL) = 1 ];
then
	cat << END > content.html
$(for  package in "macayeal" "ice" "cielo_serial" "cielo_parallel"; do

	#enter title
	if [ $package == "macayeal" ]; then
		echo "<div class=\"issmh2\">MacAyeal package</div>"
	fi
	if [ $package == "ice" ]; then
		echo "<div class=\"issmh2\">Ice package</div>"
	fi
	if [ $package == "cielo_serial" ]; then
		echo "<div class=\"issmh2\">Cielo Serial package</div>"
	fi
	if [ $package == "cielo_parallel" ]; then
		echo "<div class=\"issmh2\">Cielo Parallel package</div>"
	fi

	#Print division
	echo "<div class=\"issmbody\">"

	#check that at least one Test exists
	if [ `wc -l $package.log | awk '{printf("%s",$1);}'`  = "0" ]; then

		#No Test: use a table to fix entourage bug.
		echo "<table width=\"20%\" style=\"color:#FF0000; font-size:14px;\"><tr><td align=\"center\">No test found.</td></tr></table>"

	else

		echo "<table cellspacing=\"-1\" width=\"100%\" style=\"font-family: Arial, Verdana, Tahoma; color: #404040;\">"
		echo "<tr> <th style=\"font-size:14px;\">Result</th> <th style=\"font-size:14px;\">Tolerance</th> <th style=\"font-size:14px;\">Test</th>  <th style=\"font-size:14px;\">Solution</th> <th style=\"font-size:14px;\">Field</th> </tr>"

		# go through the lines of $package.log
		COUNTER=0
		MAX=`wc -l $package.log | awk '{printf("%s",$1);}'`
		while [  $COUNTER -lt $MAX ]; do
			let COUNTER=COUNTER+1 

			echo "<tr>"

			#see wether it is success or error (get color: red or green)
			if [ "`cat $package.log | awk '{ printf "line%so %s\n", NR, $0 }' | awk '/line'$COUNTER'o/ {printf("%s\n",$2);}';`" == "SUCCESS" ];  
			then 
				color="bgcolor=#ddffdd";
			else
				color="bgcolor=#ffdddd";
			fi

			#build html corresponding line
			cat $package.log | awk '{ printf "line%so %s\n", NR, $0 }' | awk '/line'$COUNTER'o/ {printf("<td '$color' style=\"font-size:14px;\">%s</td><td '$color' style=\"font-size:14px;\"> %s%s%s</td><td '$color' style=\"font-size:14px;\"> %s</td><td '$color' style=\"font-size:14px;\"> %s</td><td '$color' style=\"font-size:14px;\"> %s</td>",$2,$4,$5,$6,$8,$10,$14);}';
			echo "</tr>"
		done

		echo "</table>"
	fi

	#Print end division and remove log file
	echo "</div>"
	rm $package.log

done)
<br>
END
else
	for  package in "macayeal" "ice" "cielo_serial" "cielo_parallel"; do
		rm $package.log
	done
fi

#last footer
cat << END > footer.html
<br>
<div class="issmfooter"><a href="http://issm.jpl.nasa.gov" title="ISSM website" target="_blank">ISSM</a> nightly run report</div>
</body>
</html>
END

#concatenate files
if [ $(echo $IS_INSTALL) = 1 ];
then
	cat header.html summary.html content.html footer.html > report.html
	rm  header.html summary.html content.html footer.html
else
	cat header.html summary.html footer.html > report.html
	rm  header.html summary.html footer.html
fi
