%PLANET class definition
%
%   Usage:
%      md = planet(varargin)

classdef planet < model
    properties (SetAccess=public) %Planet fields
	 end
	 methods
		 function md = planet(varargin) % {{{

			 switch nargin
				 case 0
					 md=setdefaultparameters(md);
				 otherwise
					 error('planet constructor error message: 0 of 1 argument only in input.');
				 end
		 end
		 %}}}
		 function md = setdefaultparameters(md) % {{{

			 %initialize subclasses
			 md.mesh             = planetmesh();
			 md.mask             = mask();
			 md.constants        = constants();
			 md.geometry         = geometry();
			 md.initialization   = initialization();
			 md.surfaceforcings  = surfaceforcings();
			 md.basalforcings    = basalforcings();
			 md.friction         = friction();
			 md.rifts            = rifts();
			 md.timestepping     = timestepping();
			 md.groundingline    = groundingline();
			 md.materials        = materials();
			 md.flowequation     = flowequation();
			 md.debug            = debug();
			 md.verbose          = verbose('solution',true,'qmu',true,'control',true);
			 md.settings         = settings();
			 md.solver           = solver();
			 if ismumps(),
				 md.solver           = addoptions(md.solver,DiagnosticVertAnalysisEnum(),mumpsoptions());
			 else
				 md.solver           = addoptions(md.solver,DiagnosticVertAnalysisEnum(),iluasmoptions());
			 end
			 md.cluster          = generic();
			 md.balancethickness = balancethickness();
			 md.diagnostic       = diagnostic();
			 md.hydrology        = hydrology();
			 md.masstransport       = masstransport();
			 md.thermal          = thermal();
			 md.steadystate      = steadystate();
			 md.transient        = transient();
			 md.autodiff         = autodiff();
			 md.flaim            = flaim();
			 md.inversion        = inversion();
			 md.qmu              = qmu();
			 md.radaroverlay     = radaroverlay();
			 md.results          = struct();
			 md.miscellaneous    = miscellaneous();
			 md.private          = private();
		 end
		 %}}}
	 end
 end
