from MatlabFuncs import *
from model import *
from EnumDefinitions import *
from numpy import *
from triangle import *
from setmask import *
from parameterize import *
from setflowequation import *
from solve import *

md=triangle(model(),'../Exp/Square.exp',180000)
md=setmask(md,'all','')
md=parameterize(md,'../Par/SquareShelf.py')
md.extrude(3,1.)
md=setflowequation(md,'SSA','all')
md.cluster=generic('name',oshostname(),'np',3)
md.transient.isdiagnostic=False
md.transient.ismasstransport=False
md.transient.isthermal=True
md.transient.isgroundingline=False
md=solve(md,TransientSolutionEnum())

# Fields and tolerances to track changes
field_names     =['Temperature1','BasalforcingsMeltingRate1','Temperature2','BasalforcingsMeltingRate2','Temperature3','BasalforcingsMeltingRate3']
field_tolerances=[1e-13,1e-6,1e-13,1e-6,1e-13,1e-6]
field_values=[\
	md.results.TransientSolution[0].Temperature,\
	md.results.TransientSolution[0].BasalforcingsMeltingRate,\
	md.results.TransientSolution[1].Temperature,\
	md.results.TransientSolution[1].BasalforcingsMeltingRate,\
	md.results.TransientSolution[2].Temperature,\
	md.results.TransientSolution[2].BasalforcingsMeltingRate,\
	]
