tolerance=1e-13;

md=model;
md.cluster=generic('name',oshostname(),'np',3);
md.miscellaneous.name='validation';

%run all scripts
for i=1:2,

	%run queuing script
	if i==1,
		disp('Checking src/ad/issm.exe ...');
		!source validation.queue
	elseif i==2,
		disp('Checking src/ad/issmROSE.exe ...');
		!source validationROSE.queue
	end

	%load solution and remove outbin
	md=loadresultsfromdisk(md,'validation.outbin');
	!rm validation.outbin

	s=load('Archive.mat'); h0=s.thickness;
	h=md.results.MasstransportSolution.Thickness;
	error_diff=full(max(abs(h-h0))/(max(abs(h0))+eps));
	if (error_diff>tolerance);
		disp(sprintf(['\nERROR   difference: %-7.2g > %7.2g \n'],error_diff,tolerance));
	else
		disp(sprintf(['\nSUCCESS difference: %-7.2g < %7.2g \n'],error_diff,tolerance));
	end
end
