#!/bin/bash
set -eu

#Some cleanup
rm -rf src  install

#Mercurial cloning: 
hg clone http://mercurial.mcs.anl.gov//ad/AdjoinableMPI src

export C_INCLUDE_PATH=:/usr/include/sys/:$C_INCLUDE_PATH

#Configure adjoinablempi
cd src
autoreconf -fi

./configure \
	--prefix="$ISSM_DIR/externalpackages/adjoinablempi/install" --libdir="$ISSM_DIR/externalpackages/adjoinablempi/install/lib" --enable-requestOnTrace

#Compile adjoinablempi 
make clean
if [ $# -eq 0 ]; then
	make 
else
	make -j $1
fi
make install
