/*
 * CreateNodesDiagnosticSIA.c:
 */

#include "../../../toolkits/toolkits.h"
#include "../../../classes/classes.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../ModelProcessorx.h"

void	CreateNodesDiagnosticSIA(Nodes** pnodes, IoModel* iomodel){

	/*Intermediaries*/
	bool  isSIA;
	Node* node = NULL;

	/*Fetch parameters: */
	iomodel->Constant(&isSIA,FlowequationIsSIAEnum);

	/*Now, is the flag isSIA on? otherwise, do nothing: */
	if(!isSIA) return;

	/*First create nodes*/
	Nodes* nodes=*pnodes;
	if(!nodes) nodes = new Nodes();

	iomodel->FetchData(8,MeshVertexonbedEnum,MeshVertexonsurfaceEnum,FlowequationBorderSSAEnum,FlowequationBorderFSEnum,
				MaskVertexongroundediceEnum,MaskVertexonfloatingiceEnum,FlowequationVertexEquationEnum,DiagnosticReferentialEnum);

	for(int i=0;i<iomodel->numberofvertices;i++){
		if(iomodel->my_vertices[i]){

			/*Create new node if is in this processor's partition*/
			node = new Node(iomodel->nodecounter+i+1,i,i,iomodel,DiagnosticSIAAnalysisEnum,reCast<int>(iomodel->Data(FlowequationVertexEquationEnum)[i]));

			/*Deactivate node if not SIA*/
			if(reCast<int>(iomodel->Data(FlowequationVertexEquationEnum)[i])!=SIAApproximationEnum){
				node->Deactivate();
			}

			/*Add to Nodes dataset*/
			nodes->AddObject(node);
		}
	}

	iomodel->DeleteData(8,MeshVertexonbedEnum,MeshVertexonsurfaceEnum,FlowequationBorderSSAEnum,FlowequationBorderFSEnum,
				MaskVertexongroundediceEnum,MaskVertexonfloatingiceEnum,FlowequationVertexEquationEnum,DiagnosticReferentialEnum);

	/*Assign output pointer: */
	*pnodes=nodes;
}
