/*
 * CreateNodesDiagnosticHoriz.c:
 */

#include "../../../toolkits/toolkits.h"
#include "../../../classes/classes.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../ModelProcessorx.h"

void	CreateNodesDiagnosticHoriz(Nodes** pnodes, IoModel* iomodel){

	/*Intermediary*/
	bool isSSA,isL1L2,isHO,isFS,iscoupling;
	int  temp,finiteelement=-1,approximation=-1;

	/*Fetch parameters: */
	iomodel->Constant(&isSSA,FlowequationIsSSAEnum);
	iomodel->Constant(&isL1L2,FlowequationIsL1L2Enum);
	iomodel->Constant(&isHO,FlowequationIsHOEnum);
	iomodel->Constant(&isFS,FlowequationIsFSEnum);

	/*Now, check that we have non SIA elements */
	if(!isSSA & !isL1L2 & !isHO & !isFS) return;

	/*Do we have coupling*/
	if( (isSSA?1.:0.) + (isL1L2?1.:0.) + (isHO?1.:0.) + (isFS?1.:0.) >1.)
	 iscoupling = true;
	else
	 iscoupling = false;

	/*If no coupling, call Regular CreateNodes, else, use P1 elements only*/
	if(!iscoupling){

		/*Get finite element type*/
		if(isSSA){
			approximation=SSAApproximationEnum;
			iomodel->Constant(&temp,FlowequationFeSSAEnum);
			switch(temp){
				case 0 : finiteelement = P1Enum;                break; 
				case 1 : finiteelement = P2Enum;                break; 
				case 2 : finiteelement = P1bubblecondensedEnum; break; 
				case 3 : finiteelement = P1bubbleEnum;          break; 
				default: _error_("finite element "<<temp<<" not supported");
			}
		}
		else if(isL1L2){
			approximation = L1L2ApproximationEnum;
			finiteelement = P1Enum;
		}
		else if(isHO){
			approximation = HOApproximationEnum;
			iomodel->Constant(&temp,FlowequationFeHOEnum);
			switch(temp){
				case 0 : finiteelement = P1Enum;                break; 
				case 1 : finiteelement = P1xP2Enum;             break; 
				case 2 : finiteelement = P2xP1Enum;             break; 
				case 3 : finiteelement = P2Enum;                break; 
				case 4 : finiteelement = P1bubblecondensedEnum; break; 
				case 5 : finiteelement = P1bubbleEnum;          break; 
				default: _error_("finite element "<<temp<<" not supported");
			}
		}
		else if(isFS){
			approximation = FSApproximationEnum;
			iomodel->Constant(&temp,FlowequationFeFSEnum);
			switch(temp){
				case 0 : finiteelement = P1P1Enum;          break;
				case 1 : finiteelement = P1P1GLSEnum;       break;
				case 2 : finiteelement = MINIcondensedEnum; break;
				case 3 : finiteelement = MINIEnum;          break;
				case 4 : finiteelement = TaylorHoodEnum;    break;
				default: _error_("finite element "<<temp<<" not supported");
			}
		}
		iomodel->FetchData(9,MeshVertexonbedEnum,MeshVertexonsurfaceEnum,FlowequationBorderSSAEnum,FlowequationBorderFSEnum,
					MaskVertexongroundediceEnum,MaskVertexonfloatingiceEnum,MaskVertexonwaterEnum,FlowequationVertexEquationEnum,DiagnosticReferentialEnum);
		CreateNodes(pnodes,iomodel,DiagnosticHorizAnalysisEnum,finiteelement,approximation);
		iomodel->DeleteData(9,MeshVertexonbedEnum,MeshVertexonsurfaceEnum,FlowequationBorderSSAEnum,FlowequationBorderFSEnum,
					MaskVertexongroundediceEnum,MaskVertexonfloatingiceEnum,MaskVertexonwaterEnum,FlowequationVertexEquationEnum,DiagnosticReferentialEnum);
	}
	else{
		/*Coupling: we are going to create P1 Elements only*/

		/*Recover nodes*/
		Nodes* nodes = *pnodes;
		Node*  node  = NULL;
		if(!nodes) nodes = new Nodes();

		iomodel->FetchData(9,MeshVertexonbedEnum,MeshVertexonsurfaceEnum,FlowequationBorderSSAEnum,FlowequationBorderFSEnum,
					MaskVertexongroundediceEnum,MaskVertexonfloatingiceEnum,MaskVertexonwaterEnum,FlowequationVertexEquationEnum,DiagnosticReferentialEnum);
		if(isFS){
			/*P1+ velocity*/
			for(int i=0;i<iomodel->numberofvertices;i++){
				if(iomodel->my_vertices[i]){
					approximation=reCast<int>(iomodel->Data(FlowequationVertexEquationEnum)[i]);
					if(approximation==FSApproximationEnum)  approximation=FSvelocityEnum;
					nodes->AddObject(new Node(iomodel->nodecounter+i+1,i,i,iomodel,DiagnosticHorizAnalysisEnum,approximation));
				}
			}
			for(int i=0;i<iomodel->numberofelements;i++){
				if(iomodel->my_elements[i]){
					node = new Node(iomodel->nodecounter+iomodel->numberofvertices+i+1,iomodel->numberofvertices+i,0,iomodel,DiagnosticHorizAnalysisEnum,FSvelocityEnum);
					node->Deactivate();
					nodes->AddObject(node);
				}
			}
			/*P1 pressure*/
			for(int i=0;i<iomodel->numberofvertices;i++){
				if(iomodel->my_vertices[i]){
					approximation=reCast<int>(iomodel->Data(FlowequationVertexEquationEnum)[i]);
					node = new Node(iomodel->nodecounter+iomodel->numberofvertices+iomodel->numberofelements+i+1,iomodel->numberofvertices+iomodel->numberofelements+i,i,iomodel,DiagnosticHorizAnalysisEnum,FSpressureEnum);
					if(approximation==HOApproximationEnum || approximation==SSAApproximationEnum){
						node->Deactivate();
					}
					nodes->AddObject(node);
				}
			}
		}
		else{
			for(int i=0;i<iomodel->numberofvertices;i++){
				if(iomodel->my_vertices[i]){
					nodes->AddObject(new Node(iomodel->nodecounter+i+1,i,i,iomodel,DiagnosticHorizAnalysisEnum,reCast<int>(iomodel->Data(FlowequationVertexEquationEnum)[i])));
				}
			}
		}
		iomodel->DeleteData(9,MeshVertexonbedEnum,MeshVertexonsurfaceEnum,FlowequationBorderSSAEnum,FlowequationBorderFSEnum,
					MaskVertexongroundediceEnum,MaskVertexonfloatingiceEnum,MaskVertexonwaterEnum,FlowequationVertexEquationEnum,DiagnosticReferentialEnum);

		/*Assign output pointer: */
		*pnodes=nodes;
	}
}
