/*!\file DoubleElementResult.c
 * \brief: implementation of the DoubleElementResult object
 */

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../classes.h"
#include "../../shared/shared.h"

/*DoubleElementResult constructors and destructor*/
/*FUNCTION DoubleElementResult::DoubleElementResult(){{{*/
DoubleElementResult::DoubleElementResult(){
	return;
}
/*}}}*/
/*FUNCTION DoubleElementResult::DoubleElementResult(int in_enum_type,IssmDouble in_value,int in_step, IssmDouble in_time){{{*/
DoubleElementResult::DoubleElementResult(int in_enum_type,IssmDouble in_value,int in_step, IssmDouble in_time){

	enum_type=in_enum_type;
	value=in_value;
	step=in_step;
	time=in_time;
}
/*}}}*/
/*FUNCTION DoubleElementResult::~DoubleElementResult(){{{*/
DoubleElementResult::~DoubleElementResult(){
	return;
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION DoubleElementResult::Echo {{{*/
void DoubleElementResult::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION DoubleElementResult::DeepEcho{{{*/
void DoubleElementResult::DeepEcho(void){

	_printf_("DoubleElementResult:\n");
	_printf_("   enum: " << this->enum_type << " (" << EnumToStringx(this->enum_type) << ")\n");
	_printf_("   value: " << this->value << "\n");
	_printf_("   step: " << this->step << "\n");
	_printf_("   time: " << this->time << "\n");
}
/*}}}*/
/*FUNCTION DoubleElementResult::Id{{{*/
int    DoubleElementResult::Id(void){ return -1; }
/*}}}*/
/*FUNCTION DoubleElementResult::ObjectEnum{{{*/
int DoubleElementResult::ObjectEnum(void){

	return DoubleElementResultEnum;

}
/*}}}*/
/*FUNCTION DoubleElementResult::copy{{{*/
Object* DoubleElementResult::copy() {

	return new DoubleElementResult(this->enum_type,this->value,this->step,this->time);

}
/*}}}*/

/*ElementResult management*/
/*FUNCTION DoubleElementResult::InstanceEnum{{{*/
int DoubleElementResult::InstanceEnum(void){

	return this->enum_type;

}
/*}}}*/
/*FUNCTION DoubleElementResult::NumberOfNodalValues{{{*/
int DoubleElementResult::NumberOfNodalValues(void){
	return 1;
}
/*}}}*/
/*FUNCTION DoubleElementResult::PatchFill{{{*/
void DoubleElementResult::PatchFill(int row, Patch* patch){

	 /*Here, we fill the result information into the patch object. First, let's remember what is in a row 
	  * of the patch object: enum_type step time element_id interpolation vertices_ids nodal_values
	  * Here, we will supply the enum_type, step, time, interpolation and nodal_values: */
	patch->fillresultinfo(row,this->enum_type,this->step,this->time,P0Enum,&this->value,1);

}
/*}}}*/
/*FUNCTION DoubleElementResult::GetVectorFromResults{{{1*/
void DoubleElementResult::GetVectorFromResults(Vector<IssmDouble>* vector,int* doflist,int* connectivitylist,int numdofs){

	_error_("cannot return vector on vertices");
} /*}}}*/
/*FUNCTION DoubleElementResult::GetElementVectorFromResults{{{1*/
void DoubleElementResult::GetElementVectorFromResults(Vector<IssmDouble>* vector,int dof){

	vector->SetValue(dof,value,INS_VAL);
} /*}}}*/
