/*! \file DoubleElementResult.h 
 *  \brief: header file for IssmDouble result object
 *  A IssmDouble result object is just derived from a DoubleInput object, with additional time and step information.
 */

#ifndef _DOUBLEELEMENTRESULT_H_
#define _DOUBLEELEMENTRESULT_H_

/*Headers:*/
#include "../Inputs/Input.h"
class Parameters;

class DoubleElementResult: public ElementResult{

	private: 
		int        enum_type;
		IssmDouble value;
		int        step;
		IssmDouble time;

	public:

		/*DoubleElementResult constructors, destructors:*/
		DoubleElementResult();
		DoubleElementResult(int enum_type,IssmDouble value,int step,IssmDouble time);
		~DoubleElementResult();

		/*Object virtual functions definitions:*/
		void    Echo();
		void    DeepEcho();
		int     Id(); 
		int     ObjectEnum();
		Object* copy();

		/*ElementResult virtual functions definitions: {{{*/
		IssmDouble  GetTime(void){return time;};
		int     GetStep(void){return step;};
		int     NumberOfNodalValues(void);
		void    PatchFill(int row, Patch* patch);

		/*DoubleElementResult management*/
		int  InstanceEnum();
		void GetVectorFromResults(Vector<IssmDouble>* vector,int* doflist,int* connectivitylist,int numdofs);
		void GetElementVectorFromResults(Vector<IssmDouble>* vector,int dof);
};
#endif  /* _DOUBLEELEMENTRESULT_H */
