%STARTUP - Matlab startup script
%
%   startup.m is a script run by matlab at the beginning of a session, just before 
%   handing over the prompt to the user. This delivery startup.m script has been customized here for 
%   the ISSM code. This startup script should be run by users before trying to use ISSM. The best way 
%   to do that is to put the startup file in the location where Matlab starts and established its root
%   directory.
%
%   Copyright Jet Propulsion Laboratory. 

global ISSM_DIR 
lastwarn(''); % clear the last warning to focus on the warnings of the ISSM path

%Recover ISSM_DIR 
if ispc,
	[status,ISSM_DIR]=system('echo [%ISSM_DIR_WIN%]');
else
	[status,ISSM_DIR]=system('echo $ISSM_DIR');
end
if status~=0,
	error('issmdir error message: problem when running ''echo $ISSM_DIR'' shell command');
end
if (length(ISSM_DIR)<=1),
	error('issmdir error message: ''ISSM_DIR'' environment variable is empty! You should define ISSM_DIR in your .cshrc or .bashrc!');
end
%get rid of useless symbols in the name
if ispc,
ISSM_DIR=ISSM_DIR(2:end-2); 
else
ISSM_DIR=ISSM_DIR(1:end-1); 
end
clear status;

%Now add all issm code paths necessary to run issm smoothly. 
%We capture the error output, so that we can warn the user to update 
%the variable ISSM_DIR in this file, in case it is not correctly setup. 

%ISSM path
addpath([ISSM_DIR '/src/m/utils/']); %loads genpath_ice
addpath([ISSM_DIR '/etc']);
addpath([ISSM_DIR '/doc']);
addpath([ISSM_DIR '/bin']);
addpath(genpath_ice([ISSM_DIR '/src/m']));
addpath(genpath_ice([ISSM_DIR '/src/pro']));

%Check on any warning messages that might indicate that the paths were not correct. 
if ~isempty(lastwarn),
	fprintf('\n  Error trying to setup ''ISSM'' code paths. Try and update the ISSM_DIR variable in your .cshrc or .bashrc!\n');
	fprintf('  ''ISSM'' will not  work at all until this is resolved\n\n');
else
	fprintf('\n  To get started with ISSM, type issmdoc at the command prompt.\n\n');
end

%  deal with Matlab bug (on Linux, not WinXP) -- unless
%  the class has been called, "empty" method can not be found
normal_uncertain;
continuous_design;
continuous_state;
linear_inequality_constraint;
linear_equality_constraint;
response_function;
objective_function;
least_squares_term;
nonlinear_inequality_constraint;
nonlinear_equality_constraint;

