md=triangle(model(),'../Exp/Square.exp',150000.);
md=setmask(md,'all','');
md=parameterize(md,'../Par/SquareShelf.par');
md=extrude(md,3,2.);
md=setflowequation(md,'FS','all');
md.flowequation.fe_FS=4;
md.cluster=generic('name',oshostname(),'np',3);
md=solve(md,DiagnosticSolutionEnum());

%Fields and tolerances to track changes
field_names     ={'Vx','Vy','Vz','Vel','Pressure'};
field_tolerances={1e-7,1e-7,1e-7,1e-7,1e-7};
field_values={...
	(md.results.DiagnosticSolution.Vx),...
	(md.results.DiagnosticSolution.Vy),...
	(md.results.DiagnosticSolution.Vz),...
	(md.results.DiagnosticSolution.Vel),...
	(md.results.DiagnosticSolution.Pressure),...
	};
