from model import *
from triangle import *
from setmask import *
from parameterize import *
from setflowequation import *
from EnumDefinitions import *
from solve import *
from MatlabFuncs import *
from ContourToMesh import *

md=triangle(model(),'../Exp/Square.exp',150000.);
md=setmask(md,'all','');
md=parameterize(md,'../Par/SquareShelf.py');
md.extrude(3,2.)
md=setflowequation(md,'HO','all');
md.flowequation.fe_HO=3;
md.cluster=generic('name',oshostname(),'np',3);
md=solve(md,DiagnosticSolutionEnum());

#Fields and tolerances to track changes
field_names     =['Vx', 'Vy', 'Vz', 'Vel','Pressure'];
field_tolerances=[1e-12,1e-12,1e-12,1e-12,1e-13];
field_values=[\
	md.results.DiagnosticSolution.Vx,\
	md.results.DiagnosticSolution.Vy,\
	md.results.DiagnosticSolution.Vz,\
	md.results.DiagnosticSolution.Vel,\
	md.results.DiagnosticSolution.Pressure,\
	];
