/*!\file Matice.h
 * \brief: header file for matice object
 */

#ifndef MATICE_H_
#define MATICE_H_

/*Headers:*/
/*{{{*/
#include "./Material.h"
#include "../Hook.h"
class IoModel;
class Elements;
class Loads;
class Nodes;
class Vertices;
class Materials;
class Parameters;
/*}}}*/

class Matice: public Material{

	private: 
		int   mid;
		Hook *helement;

	public:
		/*Matice constructors, destructors: {{{*/
		Matice();
		Matice(int mid,int i, IoModel* iomodel);
		~Matice();
		/*}}}*/
		/*Object virtual functions definitions:{{{ */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   ObjectEnum();
		Object* copy();
		/*}}}*/
		/*Update virtual functions definitions: {{{*/
		void  InputUpdateFromVector(IssmDouble* vector, int name, int type);
		void  InputUpdateFromVector(int* vector, int name, int type);
		void  InputUpdateFromVector(bool* vector, int name, int type);
		void  InputUpdateFromMatrixDakota(IssmDouble* matrix, int nrow, int ncols, int name, int type);
		void  InputUpdateFromVectorDakota(IssmDouble* vector, int name, int type);
		void  InputUpdateFromVectorDakota(int* vector, int name, int type);
		void  InputUpdateFromVectorDakota(bool* vector, int name, int type);
		void  InputUpdateFromConstant(IssmDouble constant, int name);
		void  InputUpdateFromConstant(int constant, int name);
		void  InputUpdateFromConstant(bool constant, int name);
		void  InputUpdateFromSolution(IssmDouble* solution);
		void  InputUpdateFromIoModel(int index, IoModel* iomodel);
		/*}}}*/
		/*Material virtual functions resolution: {{{*/
		void   InputDuplicate(int original_enum,int new_enum);
		void   Configure(Elements* elements);
		void   GetVectorFromInputs(Vector<IssmDouble>* vector,int input_enum);
		void       SetCurrentConfiguration(Elements* elements,Loads* loads,Nodes* nodes,Vertices* vertices,Materials* materials,Parameters* parameters);
		void       GetViscosity2d(IssmDouble* pviscosity, IssmDouble* pepsilon);
		void       GetViscosity3d(IssmDouble* pviscosity3d, IssmDouble* pepsilon);
		void       GetViscosity3dFS(IssmDouble* pviscosity3d, IssmDouble* epsilon);
		void       GetViscosityComplement(IssmDouble* pviscosity_complement, IssmDouble* pepsilon);
		void GetViscosityZComplement(IssmDouble*, IssmDouble*){_error_("not supported");};
		void       GetViscosityDerivativeEpsSquare(IssmDouble* pmu_prime, IssmDouble* pepsilon);
		void       GetViscosityDerivativeEpsSquareFS(IssmDouble* pmu_prime, IssmDouble* pepsilon);
		void       GetViscosity2dDerivativeEpsSquare(IssmDouble* pmu_prime, IssmDouble* pepsilon);
		IssmDouble GetA();
		IssmDouble GetB();
		IssmDouble GetBbar();
		IssmDouble GetZ(){_error_("not supported");};
		IssmDouble GetZbar(){_error_("not supported");};
		IssmDouble GetN();
		bool       IsInput(int name);
		/*}}}*/
};

#endif  /* _MATICE_H_ */
