/*!\file:  Material.h
 * \brief abstract class for Material object
 */ 

#ifndef _MATERIAL_H_
#define _MATERIAL_H_

/*Headers:*/
/*{{{*/
class Inputs;
template <class doubletype> class Vector;
#include "../../datastructures/datastructures.h"
#include "../Update.h"
class Elements;
/*}}}*/

class Material: public Object,public Update{

	public: 
		Inputs*  inputs;
		virtual       ~Material(){};
		/*WARNING: input should not be public but it is an easy way to update B from T (using UpdateFromSolution) from Pentas*/

		/*Numerics*/
		virtual void       InputDuplicate(int original_enum,int new_enum)=0;
		virtual void       Configure(Elements* elements)=0;
		virtual void       GetVectorFromInputs(Vector<IssmDouble>* vector,int input_enum)=0;
		virtual void       GetViscosity2d(IssmDouble* pviscosity, IssmDouble* pepsilon)=0;
		virtual void       GetViscosity3d(IssmDouble* pviscosity3d, IssmDouble* pepsilon)=0;
		virtual void       GetViscosity3dFS(IssmDouble* pviscosity3d, IssmDouble* epsilon)=0;
		virtual void       GetViscosityComplement(IssmDouble* pviscosity_complement, IssmDouble* pepsilon)=0;
		virtual void       GetViscosityZComplement(IssmDouble* pviscosity_complement, IssmDouble* pepsilon)=0;
		virtual void       GetViscosityDerivativeEpsSquare(IssmDouble* pmu_prime, IssmDouble* pepsilon)=0;
		virtual void       GetViscosityDerivativeEpsSquareFS(IssmDouble* pmu_prime, IssmDouble* pepsilon)=0;
		virtual void       GetViscosity2dDerivativeEpsSquare(IssmDouble* pmu_prime, IssmDouble* pepsilon)=0;
		virtual IssmDouble GetA()=0;
		virtual IssmDouble GetB()=0;
		virtual IssmDouble GetBbar()=0;
		virtual IssmDouble GetN()=0;
		virtual IssmDouble GetZ()=0;
		virtual IssmDouble GetZbar()=0;

};
#endif
