/*! \file CreateLoadsHydrologyDCInefficient.c:
 */

#include "../../../toolkits/toolkits.h"
#include "../../../classes/classes.h"
#include "../../../shared/shared.h"
#include "../ModelProcessorx.h"

void	CreateLoadsHydrologyDCInefficient(Loads** ploads, IoModel* iomodel){

	/*Recover pointer: */
	Loads* loads=*ploads;

	/*Fetch parameters: */
	int hydrology_model;
	iomodel->Constant(&hydrology_model,HydrologyModelEnum);
	if(hydrology_model!=HydrologydcEnum) return;

	iomodel->FetchData(1,MeshVertexonbedEnum);

	//create penalties for nodes: no node can have a temperature over the melting point
	CreateSingleNodeToElementConnectivity(iomodel);
	for(int i=0;i<iomodel->numberofvertices;i++){
		if (iomodel->dim==3){
			/*keep only this partition's nodes:*/
			if((iomodel->my_vertices[i]==1)){
				loads->AddObject(new Pengrid(iomodel->loadcounter+i+1,i,iomodel,HydrologyDCInefficientAnalysisEnum));
			}
		}
		else if(reCast<int>(iomodel->Data(MeshVertexonbedEnum)[i])){
			if((iomodel->my_vertices[i]==1)){
				loads->AddObject(new Pengrid(iomodel->loadcounter+i+1,i,iomodel,HydrologyDCInefficientAnalysisEnum));
			}	
		}
	}
	/*Assign output pointer: */
	*ploads=loads;
	iomodel->DeleteData(1,MeshVertexonbedEnum);
}
