/*
 * CreateNodesDiagnosticHoriz.c:
 */

#include "../../../toolkits/toolkits.h"
#include "../../../classes/classes.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../ModelProcessorx.h"

void	CreateNodesDiagnosticHoriz(Nodes** pnodes, IoModel* iomodel){

	/*Intermediary*/
	bool isSSA,isL1L2,isHO,isFS,iscoupling;
	int  temp,finiteelement=-1,approximation=-1;

	/*Fetch parameters: */
	iomodel->Constant(&isSSA,FlowequationIsSSAEnum);
	iomodel->Constant(&isL1L2,FlowequationIsL1L2Enum);
	iomodel->Constant(&isHO,FlowequationIsHOEnum);
	iomodel->Constant(&isFS,FlowequationIsFSEnum);

	/*Now, check that we have non SIA elements */
	if(!isSSA & !isL1L2 & !isHO & !isFS) return;

	/*Do we have coupling*/
	if( (isSSA?1.:0.) + (isL1L2?1.:0.) + (isHO?1.:0.) + (isFS?1.:0.) >1.)
	 iscoupling = true;
	else
	 iscoupling = false;

	/*If no coupling, call Regular CreateNodes, else, use P1 elements only*/
	if(!iscoupling){

		/*Get finite element type*/
		if(isSSA){
			approximation=SSAApproximationEnum;
			iomodel->Constant(&temp,FlowequationFeSSAEnum);
			switch(temp){
				case 0 : finiteelement = P1Enum; break;
				case 1 : finiteelement = P2Enum; break;
				default: _error_("finite element "<<temp<<" not supported");
			}
		}
		else if(isL1L2){
			approximation = L1L2ApproximationEnum;
			finiteelement = P1Enum;
		}
		else if(isHO){
			approximation = HOApproximationEnum;
			iomodel->Constant(&temp,FlowequationFeHOEnum);
			switch(temp){
				case 0 : finiteelement = P1Enum;    break;
				case 1 : finiteelement = P2Enum;    break;
				case 2 : finiteelement = P2xP1Enum; break;
				case 3 : finiteelement = P1xP2Enum; break;
				default: _error_("finite element "<<temp<<" not supported");
			}
		}
		else if(isFS){
			approximation = FSApproximationEnum;
			finiteelement = P1Enum;
		}

		iomodel->FetchData(9,MeshVertexonbedEnum,MeshVertexonsurfaceEnum,FlowequationBorderSSAEnum,FlowequationBorderFSEnum,
					MaskVertexongroundediceEnum,MaskVertexonfloatingiceEnum,MaskVertexonwaterEnum,FlowequationVertexEquationEnum,DiagnosticReferentialEnum);
		CreateNodes(pnodes,iomodel,DiagnosticHorizAnalysisEnum,finiteelement,approximation);
		iomodel->DeleteData(9,MeshVertexonbedEnum,MeshVertexonsurfaceEnum,FlowequationBorderSSAEnum,FlowequationBorderFSEnum,
					MaskVertexongroundediceEnum,MaskVertexonfloatingiceEnum,MaskVertexonwaterEnum,FlowequationVertexEquationEnum,DiagnosticReferentialEnum);
	}
	else{
		/*Coupling: we are going to create P1 Elements only*/

		/*First create nodes*/
		Nodes* nodes=*pnodes;
		if(!nodes) nodes = new Nodes();

		iomodel->FetchData(9,MeshVertexonbedEnum,MeshVertexonsurfaceEnum,FlowequationBorderSSAEnum,FlowequationBorderFSEnum,
					MaskVertexongroundediceEnum,MaskVertexonfloatingiceEnum,MaskVertexonwaterEnum,FlowequationVertexEquationEnum,DiagnosticReferentialEnum);
		for(int i=0;i<iomodel->numberofvertices;i++){
			if(iomodel->my_vertices[i]){
				nodes->AddObject(new Node(iomodel->nodecounter+i+1,i,i,iomodel,DiagnosticHorizAnalysisEnum,reCast<int>(iomodel->Data(FlowequationVertexEquationEnum)[i])));
			}
		}
		iomodel->DeleteData(9,MeshVertexonbedEnum,MeshVertexonsurfaceEnum,FlowequationBorderSSAEnum,FlowequationBorderFSEnum,
					MaskVertexongroundediceEnum,MaskVertexonfloatingiceEnum,MaskVertexonwaterEnum,FlowequationVertexEquationEnum,DiagnosticReferentialEnum);

		/*Assign output pointer: */
		*pnodes=nodes;
	}
}
