#!/bin/bash
set -eu

if [ ! -h install ];
then
	echo "  ****************************************************************"
	echo "  *                                                              *"
	echo "  * you need create a symbolic link from matlab's root directory *"
	echo "  *                                                              *"
	echo "  * First, you need to locate matlab's root directory            *"
	echo "  * The easiest way to find it is to launch matlab and run the   *"
	echo "  * following command: matlabroot                                *"
	echo "  * Then, create a symbolic link using the command 'ln -s ' the  *"
	echo "  * target directory should be named 'install'                   *"
	echo "  *                                                              *"
	echo "  * Examples:                                                    *"
	echo "  *    ln -s /usr/local/matlab712/ install                       *"
	echo "  *    ln -s /Applications/MATLAB_R2012a.app/ install            *"
	echo "  *                                                              *"
	echo "  * run ./install.sh again to check that the link is correct     *"
	echo "  *                                                              *"
	echo "  ****************************************************************"
else

	#Read link
	DIR=$(readlink install)
	if [ -d $DIR ]
	then
		echo "Symbolic link correctly set"
	else
		rm -rf install
		echo "Incorrect symbolic link:"
		echo "provided target ($DIR) does not exist or is not a directory"
	fi
fi
