function [md package]=testsgetpackage(md,string),
%TESTSGETPACKAGE - build the package from a string
%
%   This routine is used by nightly runs (runme.m and updatearchive.m).
%   for an input string 'cielo_serial', it will output 'cielo'
%
%   Usage:
%      [md package]=testsgetpackage(md,string)
%
%   Example:
%      [md package]=testsgetpackage(md,'cielo_serial')
%
%   See also: TESTSGETANALYSIS, TESTSGETFIELDS

if strcmpi(string,'ice'),
	package='ice';

elseif strcmpi(string,'macayeal'),
	package='macayeal';

elseif strcmpi(string,'cielo_serial'),
	package='cielo';
	md.cluster='none';

elseif strcmpi(string,'cielo_parallel'),

	%get hostname
	[ret,name]=system('hostname -s');
	if ret,
		if ispc
			name=getenv('COMPUTERNAME');
		else
			name=getenv('HOSTNAME');
		end
	end
	md.cluster=lower(name);

	%assign package
	package='cielo';

else
	error(['testsgetpackage error message: package '  string ' not supported yet']);
end
