/*
 * UpdateElementsDiagnosticSIA:
 */

#include "../../../toolkits/toolkits.h"
#include "../../../classes/classes.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../ModelProcessorx.h"

void	UpdateElementsDiagnosticSIA(Elements* elements, IoModel* iomodel,int analysis_counter,int analysis_type){

	/*Fetch data needed: */
	bool   isSIA;
	iomodel->Constant(&isSIA,FlowequationIsSIAEnum);

	/*Now, is the flag SIA on? otherwise, do nothing: */
	if (!isSIA)return;

	iomodel->FetchData(1,FlowequationElementEquationEnum);

	/*Update elements: */
	int counter=0;
	for(int i=0;i<iomodel->numberofelements;i++){
		if(iomodel->my_elements[i]){
			Element* element=(Element*)elements->GetObjectByOffset(counter);
			element->Update(i,iomodel,analysis_counter,analysis_type,P1Enum);
			counter++;
		}
	}

	iomodel->FetchDataToInput(elements,ThicknessEnum);
	iomodel->FetchDataToInput(elements,GeometryHydrostaticRatioEnum);

	/*Free data: */
	iomodel->DeleteData(1,FlowequationElementEquationEnum);
}
