from fielddisplay import fielddisplay
from EnumDefinitions import *
from checkfield import *
from WriteData import *

class mask(object):
	"""
	MASK class definition

	   Usage:
	      mask=mask();
	"""

	def __init__(self): # {{{
		self.elementonfloatingice = float('NaN')
		self.elementongroundedice = float('NaN')
		self.elementonwater       = float('NaN')
		self.vertexonfloatingice  = float('NaN')
		self.vertexongroundedice  = float('NaN')
		self.vertexonwater        = float('NaN')
		self.icelevelset          = float('NaN')

		#set defaults
		self.setdefaultparameters()

		#}}}
	def __repr__(self): # {{{
		string="   masks:"

		string="%s\n%s"%(string,fielddisplay(self,"elementonfloatingice","element on floating ice flags list"))
		string="%s\n%s"%(string,fielddisplay(self,"vertexonfloatingice","vertex on floating ice flags list"))
		string="%s\n%s"%(string,fielddisplay(self,"elementongroundedice","element on grounded ice list"))
		string="%s\n%s"%(string,fielddisplay(self,"vertexongroundedice","vertex on grounded ice flags list"))
		string="%s\n%s"%(string,fielddisplay(self,"elementonwater","element on water flags list"))
		string="%s\n%s"%(string,fielddisplay(self,"vertexonwater","vertex on water flags list"))
		string="%s\n%s"%(string,fielddisplay(self,"icelevelset","presence of ice if > 0, icefront position if = 0, no ice if < 0"))
		return string
		#}}}
	def setdefaultparameters(self): # {{{
		return self
	#}}}
	def checkconsistency(self,md,solution,analyses):    # {{{

		md = checkfield(md,'mask.elementonfloatingice','size',[md.mesh.numberofelements],'values',[0,1])
		md = checkfield(md,'mask.elementongroundedice','size',[md.mesh.numberofelements],'values',[0,1])
		md = checkfield(md,'mask.elementonwater'      ,'size',[md.mesh.numberofelements],'values',[0,1])
		md = checkfield(md,'mask.vertexonfloatingice' ,'size',[md.mesh.numberofvertices],'values',[0,1])
		md = checkfield(md,'mask.vertexongroundedice' ,'size',[md.mesh.numberofvertices],'values',[0,1])
		md = checkfield(md,'mask.vertexonwater'       ,'size',[md.mesh.numberofvertices],'values',[0,1])
		md = checkfield(md,'mask.icelevelset'         ,'size',[md.mesh.numberofvertices])
		isice=numpy.zeros(md.mesh.numberofvertices,int)
		pos=npy.nonzero(md.mask.icelevelset>0)
		isice[pos]=1
		totallyicefree=(numpy.sum(isice[md.mesh.elements-1],axis=1)==0).astype(int)
		if any(totallyicefree):
			raise TypeError("elements with no ice not implemented yet, each element should have at least one vertex with md.mask.icelevelset > 0")

		return md
	# }}}
	def marshall(self,md,fid):    # {{{
		WriteData(fid,'object',self,'fieldname','elementonfloatingice','format','BooleanMat','mattype',2)
		WriteData(fid,'object',self,'fieldname','elementongroundedice','format','BooleanMat','mattype',2)
		WriteData(fid,'object',self,'fieldname','elementonwater','format','BooleanMat','mattype',2)
		WriteData(fid,'object',self,'fieldname','vertexonfloatingice','format','DoubleMat','mattype',1)
		WriteData(fid,'object',self,'fieldname','vertexongroundedice','format','DoubleMat','mattype',1)
		WriteData(fid,'object',self,'fieldname','vertexonwater','format','DoubleMat','mattype',1)
		WriteData(fid,'object',self,'fieldname','icelevelset','format','DoubleMat','mattype',1)
	# }}}
