from MatlabFuncs import *
from model import *
from EnumDefinitions import *
from numpy import *
from triangle import *
from meshprocessrifts import *
from setmask import *
from parameterize import *
from setflowequation import *
from solve import *

md=triangle(model(),'../Exp/SquareHole.exp','../Exp/Rifts.exp',50000.)
md=meshprocessrifts(md,'../Exp/Square.exp')
md=setmask(md,'all','')
md=parameterize(md,'../Par/SquareShelf2.py')
md=setflowequation(md,'SSA','all')
md.cluster=generic('name',oshostname(),'np',3)

# rift settings

md.rifts.riftstruct[0]['fill']=MelangeEnum()
md.rifts.riftstruct[0]['fraction']=0
md.diagnostic.rift_penalty_lock=2
md.diagnostic.rift_penalty_threshold=0
md.rifts.riftstruct[0]['fractionincrement']=0.1
md=solve(md,DiagnosticSolutionEnum())

# Fields and tolerances to track changes

field_names     =['Vx','Vy','Vel','Pressure']
field_tolerances=[1e-11,1e-11,1e-11,1e-11]
field_values=[\
	md.results.DiagnosticSolution.Vx,\
	md.results.DiagnosticSolution.Vy,\
	md.results.DiagnosticSolution.Vel,\
	md.results.DiagnosticSolution.Pressure,\
	]
