/*
 * CreateNodesDiagnosticSIA.c:
 */

#include "../../../toolkits/toolkits.h"
#include "../../../classes/classes.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../ModelProcessorx.h"

void	CreateNodesDiagnosticSIA(Nodes** pnodes, IoModel* iomodel){

	/*Fetch parameters: */
	bool isSIA;
	iomodel->Constant(&isSIA,FlowequationIsSIAEnum);

	/*Now, is the flag isSIA on? otherwise, do nothing: */
	if(!isSIA) return;

	/*First create nodes*/
	Nodes* nodes=*pnodes;
	if(!nodes) nodes = new Nodes();

	iomodel->FetchData(9,MeshVertexonbedEnum,MeshVertexonsurfaceEnum,FlowequationBorderSSAEnum,FlowequationBorderFSEnum,
				MaskVertexongroundediceEnum,MaskVertexonfloatingiceEnum,MaskVertexonwaterEnum,FlowequationVertexEquationEnum,DiagnosticReferentialEnum);
	for(int i=0;i<iomodel->numberofvertices;i++){
		if(iomodel->my_vertices[i]){
			nodes->AddObject(new Node(iomodel->nodecounter+i+1,i,i,iomodel,DiagnosticSIAAnalysisEnum,reCast<int>(iomodel->Data(FlowequationVertexEquationEnum)[i])));
		}
	}
	iomodel->DeleteData(9,MeshVertexonbedEnum,MeshVertexonsurfaceEnum,FlowequationBorderSSAEnum,FlowequationBorderFSEnum,
				MaskVertexongroundediceEnum,MaskVertexonfloatingiceEnum,MaskVertexonwaterEnum,FlowequationVertexEquationEnum,DiagnosticReferentialEnum);

	/*Assign output pointer: */
	*pnodes=nodes;
}
