/*!\file:  TriaRef.h
 * \brief abstract class for handling Tria oriented routines, like nodal functions, 
 * strain rate generation, etc ...
 */ 

#ifndef _TRIAREF_H_
#define _TRIAREF_H_

class GaussTria;

class TriaRef{

	public: 
		int* element_type_list; //P1CG, P1DG, MINI, P2...
		int  element_type;

		TriaRef();
		TriaRef(const int nummodels);
		~TriaRef();

		/*Management*/
		void SetElementType(int type,int type_counter);

		/*Numerics*/
		void GetBSSA(IssmDouble* B, IssmDouble* xyz_list, GaussTria* gauss);
		void GetBSSAFS(IssmDouble* B , IssmDouble* xyz_list, GaussTria* gauss);
		void GetBprimeSSA(IssmDouble* Bprime, IssmDouble* xyz_list, GaussTria* gauss);
		void GetBprimeSSAFS(IssmDouble* Bprime, IssmDouble* xyz_list, GaussTria* gauss);
		void GetBprimePrognostic(IssmDouble* Bprime, IssmDouble* xyz_list, GaussTria* gauss);
		void GetBPrognostic(IssmDouble* B, IssmDouble* xyz_list, GaussTria* gauss);
		void GetBHydro(IssmDouble* B, IssmDouble* xyz_list, GaussTria* gauss);
		void GetBSSAFriction(IssmDouble* L, IssmDouble* xyz_list,GaussTria* gauss);
		void GetJacobian(IssmDouble* J, IssmDouble* xyz_list,GaussTria* gauss);
		void GetSegmentJacobianDeterminant(IssmDouble* Jdet, IssmDouble* xyz_list,GaussTria* gauss);
		void GetJacobianDeterminant(IssmDouble* Jdet, IssmDouble* xyz_list,GaussTria* gauss);
		void GetJacobianInvert(IssmDouble*  Jinv, IssmDouble* xyz_list,GaussTria* gauss);
		void GetNodalFunctions(IssmDouble* basis,GaussTria* gauss);
		void GetSegmentNodalFunctions(IssmDouble* basis,GaussTria* gauss, int index1,int index2);
		void GetSegmentBFlux(IssmDouble* B,GaussTria* gauss, int index1,int index2);
		void GetSegmentBprimeFlux(IssmDouble* Bprime,GaussTria* gauss, int index1,int index2);
		void GetNodalFunctionsDerivatives(IssmDouble* dbasis,IssmDouble* xyz_list, GaussTria* gauss);
		void GetNodalFunctionsDerivativesReference(IssmDouble* dbasis,GaussTria* gauss);
		void GetInputValue(IssmDouble* pp, IssmDouble* plist, GaussTria* gauss);
		void GetInputDerivativeValue(IssmDouble* pp, IssmDouble* plist,IssmDouble* xyz_list, GaussTria* gauss);

		int  NumberofNodes(void);
};
#endif
