md=triangle(model(),'../Exp/Square.exp',50000.);
md=setmask(md,'','');
md=parameterize(md,'../Par/SquareSheetConstrained.par');
md=setflowequation(md,'SSA','all');
md.cluster=generic('name',oshostname(),'np',2);
md.hydrology=(hydrologydc);
md.initialization.sediment_head=0.0*ones(md.mesh.numberofvertices,1);
md.hydrology.spcsediment_head=NaN*ones(md.mesh.numberofvertices,1);
pos=find(md.mesh.x==0);
md.hydrology.spcsediment_head(pos)=0.0;
md.basalforcings.melting_rate = 2.0*ones(md.mesh.numberofvertices,1);
md.timestepping.time_step=0;
md.timestepping.final_time=1.0;
md=solve(md,HydrologySolutionEnum());

analitic=(md.mesh.x.^2-2*md.mesh.x*10^6)*(-2.0/(365*3600*24*2.0*md.hydrology.sediment_transmitivity));
plotmodel(md,'data',md.results.HydrologySolution.SedimentHead-analitic)
%plotmodel(md,'data',analitic)