md=triangle(model(),'../Exp/Square.exp',150000.);
md=setmask(md,'../Exp/SquareShelf.exp','');
md=parameterize(md,'../Par/SquareSheetShelf.par');
md=extrude(md,4,1.);
md=setflowequation(md,'L1L2','all');
md.cluster=generic('name',oshostname(),'np',3);
md=solve(md,DiagnosticSolutionEnum());

%Fields and tolerances to track changes
field_names     ={'Vx','Vy','Vz','Vel','Pressure'};
field_tolerances={1e-07,1e-06,1e-07,1e-06,1e-07};
field_values={...
	(md.results.DiagnosticSolution.Vx),...
	(md.results.DiagnosticSolution.Vy),...
	(md.results.DiagnosticSolution.Vz),...
	(md.results.DiagnosticSolution.Vel),...
	(md.results.DiagnosticSolution.Pressure),...
	};
