import numpy
from model import *
from triangle import *
from setmask import *
from parameterize import *
from setflowequation import *
from EnumDefinitions import *
from solve import *
from MatlabFuncs import *

md=triangle(model(),'../Exp/Square.exp',200000.)
md=setmask(md,'','')
md=parameterize(md,'../Par/SquareSheetConstrained.py')
md.extrude(3,1.)
md=setflowequation(md,'HO','all')

#control parameters
md.inversion.iscontrol=1
md.inversion.control_parameters=['FrictionCoefficient']
md.inversion.min_parameters=1.*numpy.ones((md.mesh.numberofvertices,1))
md.inversion.max_parameters=200.*numpy.ones((md.mesh.numberofvertices,1))
md.inversion.nsteps=2
md.inversion.cost_functions=numpy.hstack((102*numpy.ones((md.inversion.nsteps,1)),501*numpy.ones((md.inversion.nsteps,1))))
md.inversion.cost_functions_coefficients=numpy.ones((md.mesh.numberofvertices,2))
md.inversion.cost_functions_coefficients[:,1]=2*10**-7
md.inversion.gradient_scaling=3.*numpy.ones((md.inversion.nsteps,1))
md.inversion.maxiter_per_step=2*numpy.ones(md.inversion.nsteps)
md.inversion.step_threshold=0.3*numpy.ones(md.inversion.nsteps)
md.inversion.vx_obs=md.initialization.vx
md.inversion.vy_obs=md.initialization.vy

md.cluster=generic('name',oshostname(),'np',3)
md=solve(md,DiagnosticSolutionEnum())

#Fields and tolerances to track changes
field_names     =['Gradient','Misfits','FrictionCoefficient','Pressure','Vel','Vx','Vy']
field_tolerances=[1e-08,1e-07,1e-10,1e-10,1e-09,1e-09,1e-09]
field_values=[\
	md.results.DiagnosticSolution.Gradient1,\
	md.results.DiagnosticSolution.J,\
	md.results.DiagnosticSolution.FrictionCoefficient,\
	md.results.DiagnosticSolution.Pressure,\
	md.results.DiagnosticSolution.Vel,\
	md.results.DiagnosticSolution.Vx,\
	md.results.DiagnosticSolution.Vy,\
]
