import numpy
from model import *
from roundmesh import *
from setmask import *
from parameterize import *
from setflowequation import *
from EnumDefinitions import *
from solve import *
from MatlabFuncs import *

radius=1.e6
shelfextent=2.e5

md=roundmesh(model(),radius,50000.)
#fix center node to 0,0
rad=numpy.sqrt(md.mesh.x**2+md.mesh.y**2)
pos=numpy.argmin(rad)
md.mesh.x[pos]=0.
md.mesh.y[pos]=0.    #the closest node to the center is changed to be exactly at the center
xelem=numpy.mean(md.mesh.x[md.mesh.elements.astype(int)-1],axis=1)
yelem=numpy.mean(md.mesh.y[md.mesh.elements.astype(int)-1],axis=1)
rad=numpy.sqrt(xelem**2+yelem**2)
flags=numpy.zeros(md.mesh.numberofelements)
pos=numpy.nonzero(rad>=(radius-shelfextent))
flags[pos]=1
md=setmask(md,flags,'') 
md=parameterize(md,'../Par/RoundSheetShelf.py')
md=setflowequation(md,'SSA','all')
md.extrude(3,1.)
md.cluster=generic('name',oshostname(),'np',3)

md.transient.isthermal=False
md.transient.isprognostic=False
md.transient.isdiagnostic=False
md.transient.isgroundingline=True

#test different grounding line dynamics.
md.groundingline.migration='AgressiveMigration'
md=solve(md,TransientSolutionEnum())
element_on_iceshelf_agressive=md.results.TransientSolution[0].MaskElementonfloatingice

md.groundingline.migration='SoftMigration'
md=solve(md,TransientSolutionEnum())
element_on_iceshelf_soft=md.results.TransientSolution[0].MaskElementonfloatingice

md.groundingline.migration='SubelementMigration'
md=solve(md,TransientSolutionEnum())
element_on_iceshelf_subelement=md.results.TransientSolution[0].GLlevelset

#Fields and tolerances to track changes
field_names     =['ElementOnIceShelfAgressive','ElementOnIceShelfSoft','ElementOnIceShelfSubelement']
field_tolerances=[1e-13,1e-13,1e-13]
field_values=[element_on_iceshelf_agressive,element_on_iceshelf_soft,element_on_iceshelf_subelement]
