import numpy
import sys
from model import *
from triangle import *
from setmask import *
from parameterize import *
from setflowequation import *
from EnumDefinitions import *
from solve import *
from MatlabFuncs import *

"""
Test on the diagnostic model and the prognostic in 2d
"""

printingflag=False

#test 5 and 6: 
md=model()
md=triangle(md,'../Exp/SquareEISMINT.exp',5100.)    #test3
md=setmask(md,'all','')
md=parameterize(md,'../Par/SquareEISMINT.py')
md=setflowequation(md,'SSA','all')    #MacAyeal's model and 2d

#Impose a non zero velocity on the upper boundary condition (y=max(y))
pos=numpy.nonzero(md.mesh.y==numpy.max(md.mesh.y))
md.diagnostic.spcvy[pos]=400.*(((md.mesh.x[pos].reshape(-1,1)-100000.)/25000.)**2-numpy.ones((numpy.size(pos),1)))*heaviside((1.+sys.float_info.epsilon)*numpy.ones((numpy.size(pos),1))-((md.mesh.x[pos].reshape(-1,1)-100000.)/25000.)**2)

#Compute solution for MacAyeal's model 
md.cluster=generic('name',oshostname(),'np',8)
md=solve(md,DiagnosticSolutionEnum())

vx=md.results.DiagnosticSolution.Vx
vy=md.results.DiagnosticSolution.Vy

#plot results
#plotmodel(md,'data',vx,'contourlevels',{0,20,40,60,80,100,-20,-40,-60,-80,-100},...
#	'contourcolor','k')
if printingflag:
	pass
#	set(gcf,'Color','w')
#	printmodel('eismintdiag2vx','png','margin','on','marginsize',25,'frame','off','resolution',2,'hardcopy','off');
#	system(['mv eismintdiag2vx.png ' ISSM_DIR '/website/doc_pdf/validation/Images/EISMINT/IceShelf ']);
#plotmodel(md,'data',vy,'contourlevels',{-100,-200,-300,-400,-500,-600,-700,-800,-900,-1000},...
#	'contourcolor','k')
if printingflag:
	pass
#	set(gcf,'Color','w')
#	printmodel('eismintdiag2vy','png','margin','on','marginsize',25,'frame','off','resolution',2,'hardcopy','off');
#	system(['mv eismintdiag2vy.png ' ISSM_DIR '/website/doc_pdf/validation/Images/EISMINT/IceShelf ']);

#Fields and tolerances to track changes
field_names     =['Vx','Vy']
field_tolerances=[1e-13,1e-13]
field_values=[\
	vx, \
	vy, \
	]
