tolerance=1e-13;

md=setmesh(model,'Square.exp',150000);
md=setmask(md,'all','');
md=parameterize(md,'SquareShelfConstrained.par');
md=setflowequation(md,'SSA','all');
md.cluster=generic('name',oshostname(),'np',3);
md.cluster.executionpath=[issmtier() '/src/ad/validation/Validation/'];

md.autodiff.isautodiff=true;
md.autodiff.forward=true;
md.verbose=verbose('solution',true);

md=solve(md,PrognosticSolutionEnum);

thickness=md.results.PrognosticSolution.Thickness;
save ../Validation/Archive.mat thickness;
