function FS=FSoptions(varargin)
%STOKESOPTIONS - return STOKES multi-physics solver petsc options
%
%   Usage:
%      options=FSoptions;

%retrieve options provided in varargin
options=pairoptions(varargin{:});
FS=struct();

%default FS options
PETSC_VERSION=petscversion();
if PETSC_VERSION==2,
	error('FSoptions error message: multi-physics options not supported in Petsc 2');
end
if PETSC_VERSION==3,
	FS.toolkit='petsc';
	FS.mat_type=getfieldvalue(options,'mat_type','mpiaij');
	FS.ksp_max_it=getfieldvalue(options,'ksp_max_it',1000);
	FS.ksp_type=getfieldvalue(options,'ksp_type','gmres');
	FS.pc_type=getfieldvalue(options,'pc_type','fieldsplit');
	FS.pc_field_split_type=getfieldvalue(options,'pc_field_split_type','schur');
	FS.fieldsplit_0_pc_type=getfieldvalue(options,'fieldsplit_0_pc_type','hypre');
	FS.fieldsplit_0_ksp_type=getfieldvalue(options,'fieldsplit_0_ksp_type','gmres');
	FS.fieldsplit_0_pc_hypre_type=getfieldvalue(options,'fieldsplit_0_pc_hypre_type','boomerang');
	FS.fieldsplit_1_pc_type=getfieldvalue(options,'fieldsplit_1_pc_type','jacobi');
	FS.fieldsplit_1_ksp_type=getfieldvalue(options,'fieldsplit_1_ksp_type','preonly');
	FS.issm_option_solver=getfieldvalue(options,'issm_option_solver','FS');
end
