/*
 * CreateNodesDiagnosticSIA.c:
 */

#include "../../../toolkits/toolkits.h"
#include "../../../classes/classes.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../ModelProcessorx.h"

void	CreateNodesDiagnosticSIA(Nodes** pnodes, IoModel* iomodel){

	/*Fetch parameters: */
	bool isSIA;
	iomodel->Constant(&isSIA,FlowequationIsSIAEnum);

	/*Now, is the flag isSIA on? otherwise, do nothing: */
	if(!isSIA) return;

	iomodel->FetchData(6,MeshVertexonbedEnum,MeshVertexonsurfaceEnum,MaskVertexongroundediceEnum,MaskVertexonfloatingiceEnum,FlowequationVertexEquationEnum,MaskVertexonwaterEnum);
	CreateNodes(pnodes,iomodel,DiagnosticSIAAnalysisEnum,P1Enum);
	iomodel->DeleteData(6,MeshVertexonbedEnum,MeshVertexonsurfaceEnum,MaskVertexongroundediceEnum,MaskVertexonfloatingiceEnum,FlowequationVertexEquationEnum,MaskVertexonwaterEnum);
}
