import os.path
import inspect
import netCDF4
from numpy import *
from verbose import *
from InterpFromMeshToMesh2d import InterpFromMeshToMesh2d
from paterson import *
from SetMarineIceSheetBC import *

#Start defining model parameters here

#Geometry and observation
f = netCDF4.Dataset('../Data/Pig.nc','r')
x         = reshape(f.variables['x'][:],(-1))
y         = reshape(f.variables['y'][:],(-1))
vx_obs    = f.variables['vx_obs'][:]
vy_obs    = f.variables['vy_obs'][:]
index     = f.variables['index'][:]
surface   = f.variables['surface'][:]
thickness = f.variables['thickness'][:]
f.close()

[md.inversion.vx_obs]   =InterpFromMeshToMesh2d(index,x,y,vx_obs,md.mesh.x,md.mesh.y)
[md.inversion.vy_obs]   =InterpFromMeshToMesh2d(index,x,y,vy_obs,md.mesh.x,md.mesh.y)
[md.geometry.surface]  =InterpFromMeshToMesh2d(index,x,y,surface,md.mesh.x,md.mesh.y)
[md.geometry.thickness]=InterpFromMeshToMesh2d(index,x,y,thickness,md.mesh.x,md.mesh.y)
md.geometry.bed=md.geometry.surface-md.geometry.thickness
md.initialization.vx=md.inversion.vx_obs
md.initialization.vy=md.inversion.vy_obs
md.initialization.vz=zeros((md.mesh.numberofvertices,1))
md.initialization.pressure=zeros((md.mesh.numberofvertices,1))

#Materials
md.initialization.temperature=(273.-20.)*ones((md.mesh.numberofvertices,1))
md.materials.rheology_B=paterson(md.initialization.temperature)
md.materials.rheology_n=3.*ones((md.mesh.numberofelements,1))
md.initialization.temperature=md.initialization.temperature

#Friction
pos=numpy.nonzero(md.mask.elementonfloatingice)
md.friction.coefficient=50.*ones((md.mesh.numberofvertices,1))
md.friction.coefficient[md.mesh.elements[pos].astype(int)-1]=0.
md.friction.p=ones((md.mesh.numberofelements,1))
md.friction.q=ones((md.mesh.numberofelements,1))

#Numerical parameters
md.diagnostic.viscosity_overshoot=0.3
md.prognostic.stabilization=1.
md.verbose=verbose(0)
md.settings.waitonlock=30
md.timestepping.time_step=1.
md.timestepping.final_time=2.
md.diagnostic.restol=0.05
md.diagnostic.reltol=1.
md.steadystate.reltol=1.
md.diagnostic.abstol=float('nan')

#Boundary conditions:
md=SetMarineIceSheetBC(md)
md.diagnostic.icefront[:,-1]=1

#Change name so that no test have the same name
if len(inspect.stack()) > 2:
	md.miscellaneous.name = os.path.basename(inspect.stack()[2][1]).split('.')[0]
