#!/bin/bash
#This bash script calls the nightlyrun.m matlab file to run our nightly test decks. 
#It then processes the results and sends an email to the Ice developpers.

#get configs
if [ $# -ne 1 ];
then
	echo "no config file specified. Exiting..."
	exit 1
else
	source $1;
fi

#create nightly run variables
export TODAY=`date | awk '{printf("%s-%s-%s",$2,$3,$6);}'`;
export HOST_NAME=`hostname`;
if [[ "$OS" == "win32xp" ]]
then
	export HOST_NAME_SHORT=`hostname`;
else
	export HOST_NAME_SHORT=`hostname -s`;
fi
export ISSM_RELEASE="issm"

#create ISSM variables
export ISSM_DIR
export ISSM_ARCH

#Erase previous code and Fetch the new one
rm -rf trunk
svn checkout $REPOSITORY

#install ISSM

#1: modify some variables
cd $ISSM_DIR/etc

#source environment variables with new matlab path
source environment.sh MATLAB_DIR=$MATLAB_PATH

#create simpler  cluster.rc file, with only the cluster we are interested in.
cat << END > cluster.rc
begin
cluster_name=$HOST_NAME_SHORT
cluster_codepath=$ISSM_DIR/bin
cluster_executionpath=$EXECUTION_PATH
end
END

#2: install some required external packages
cd $ISSM_DIR/externalpackages
for ep in $EXTERNALPACKAGES
do 
	cd $ep
	cp configs/$OS/* .
	./install.sh $NUMCPUS
	cd ..
done

#3: install automake and autoconf
cd $ISSM_DIR/devpackages
make
cd ..

#3: generate MakeFiles
sh scripts/automakererun.sh
sh configs/$OS/$OS.sh

#4: compile and install ISSM
make -j $NUMCPUS
make -j $NUMCPUS install

#Launch matlab and the nightly run script
matlab -nojvm -nosplash  > ./nightlylong.log << EOF 
startup
nightlyrun($PACKAGES);
EOF

#removed unused lines to deal with a smaller file
cat nightlylong.log | egrep 'difference: |NIGHTLYRUNTERMINATEDCORRECTLY' > nightly.log
#rm nightlylong.log

#Build html report
./cron/report.sh
		
#send mail
source cron/mailinglist
for i in `echo $MAILINGLIST`; do

if [[ "$OS" == "win32xp" ]]
then
	email -html -f "ISSM Nightly run $EMAIL_ADRESS" -s "Nightly runs of $ISSM_RELEASE on: $HOST_NAME. Date:$TODAY. " $i < report.html 
else
	cat - report.html <<HERE | /usr/lib/sendmail  -oi -t
From: "ISSM Nightly run" $EMAIL_ADRESS
To: $i
Subject: Nightly runs of $ISSM_RELEASE on: $HOST_NAME_SHORT. Date:$TODAY.
Mime-Version: 1.0
Content-Type: text/html
HERE
fi

done

#Erase log and error logs
#rm -rf nightly.log report.html

#Erase ice code
#cd ..
#rm -rf trunk/
