/*!\file:  DistributeNumDofs.cpp
 * \brief: figure out the maximum number of dofs per node.
 */ 

#include "../../shared/shared.h"
#include "../../classes/classes.h"

void DistributeNumDofs(DofIndexing* index,int analysis_type,int node_type){

	/*For now, we distribute by analysis_type, later, we will distribute using the analysis_type,
	 * but also the node_type: */

	int  numdofs = -1;   //default numdofs
	int *doftype = NULL;

	/*ok, according to analysis type: */
	switch(analysis_type){
		case DiagnosticHorizAnalysisEnum:
			switch(node_type){
				case MacAyealApproximationEnum:
					numdofs=2;
					break;
				case L1L2ApproximationEnum:
					numdofs=2;
					break;
				case PattynApproximationEnum:
					numdofs=2;
					break;
				case HutterApproximationEnum:
					numdofs=2;
					break;
				case StokesApproximationEnum:
					numdofs=4;
					break;
				case NoneApproximationEnum:
					numdofs=4;
					break;
				case MacAyealPattynApproximationEnum:
					numdofs=4;
					doftype=xNew<int>(numdofs);
					doftype[0]=MacAyealApproximationEnum;
					doftype[1]=MacAyealApproximationEnum;
					doftype[2]=PattynApproximationEnum;
					doftype[3]=PattynApproximationEnum;
					break;
				case PattynStokesApproximationEnum:
					numdofs=6;
					doftype=xNew<int>(numdofs);
					doftype[0]=PattynApproximationEnum;
					doftype[1]=PattynApproximationEnum;
					doftype[2]=StokesApproximationEnum;
					doftype[3]=StokesApproximationEnum;
					doftype[4]=StokesApproximationEnum;
					doftype[5]=StokesApproximationEnum;
					break;
				case MacAyealStokesApproximationEnum:
					numdofs=6;
					doftype=xNew<int>(numdofs);
					doftype[0]=MacAyealApproximationEnum;
					doftype[1]=MacAyealApproximationEnum;
					doftype[2]=StokesApproximationEnum;
					doftype[3]=StokesApproximationEnum;
					doftype[4]=StokesApproximationEnum;
					doftype[5]=StokesApproximationEnum;
					break;
				default:
					_error_("Approximationtype " << node_type << " (" << EnumToStringx(node_type) << ") not implemented yet for DiagnosticHoriz");

			}
			break;
		case DiagnosticVertAnalysisEnum:
			numdofs=1;
			break;
		case DiagnosticHutterAnalysisEnum:
			numdofs=2;
			break;
		case BedSlopeAnalysisEnum:
			numdofs=1;
			break;
		case SurfaceSlopeAnalysisEnum:
			numdofs=1;
			break;
		case ThermalAnalysisEnum:
			numdofs=1;
			break;
		case EnthalpyAnalysisEnum:
			numdofs=1;
			break;
		case HydrologyDCInefficientAnalysisEnum:
			numdofs=1;
			break;
		case HydrologyDCEfficientAnalysisEnum:
			numdofs=1;
			break;
		case HydrologyShreveAnalysisEnum:
			numdofs=1;
			break;
		case MeltingAnalysisEnum:
			numdofs=1;
			break;
		case PrognosticAnalysisEnum:
			numdofs=1;
			break;
		case GiaAnalysisEnum:
			numdofs=1;
			break;
		case BalancethicknessAnalysisEnum:
			numdofs=1;
			break;
		default:
			_error_("analysis type: " << analysis_type << " (" << EnumToStringx(analysis_type) << ") not implemented yet");
	}

	/*Now initialize the index*/
	index->Init(numdofs,doftype);

	/*Clean up*/
	 xDelete<int>(doftype);
}
