/*
 * UpdateElementsDiagnosticHoriz:
 */
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../../../toolkits/toolkits.h"
#include "../../../classes/classes.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../ModelProcessorx.h"

void	UpdateElementsDiagnosticHoriz(Elements* elements, IoModel* iomodel,int analysis_counter,int analysis_type){

	int    materials_type;
	bool   ismacayeal,isl1l2,ispattyn,isstokes;
	bool   control_analysis;
	bool   dakota_analysis;

	/*Fetch constants needed: */
	iomodel->Constant(&ismacayeal,FlowequationIsmacayealEnum);
	iomodel->Constant(&isl1l2,FlowequationIsl1l2Enum);
	iomodel->Constant(&ispattyn,FlowequationIspattynEnum);
	iomodel->Constant(&isstokes,FlowequationIsstokesEnum);
	iomodel->Constant(&control_analysis,InversionIscontrolEnum);
	iomodel->Constant(&dakota_analysis,QmuIsdakotaEnum);
	iomodel->Constant(&materials_type,MaterialsEnum);

	/*Now, is the flag macayaealpattyn on? otherwise, do nothing: */
	if(!ismacayeal & !isl1l2 & !ispattyn & !isstokes) return;

	/*Fetch data needed: */
	iomodel->FetchData(1,FlowequationElementEquationEnum);

	/*Update elements: */
	int counter=0;
	for(int i=0;i<iomodel->numberofelements;i++){
		if(iomodel->my_elements[i]){
			Element* element=(Element*)elements->GetObjectByOffset(counter);
			element->Update(i,iomodel,analysis_counter,analysis_type); //we need i to index into elements.
			counter++;
		}
	}

	/*Create inputs: */
	iomodel->FetchDataToInput(elements,ThicknessEnum);
	iomodel->FetchDataToInput(elements,GeometryHydrostaticRatioEnum);
	iomodel->FetchDataToInput(elements,SurfaceEnum);
	iomodel->FetchDataToInput(elements,BedEnum);
	iomodel->FetchDataToInput(elements,FrictionCoefficientEnum);
	iomodel->FetchDataToInput(elements,FrictionPEnum);
	iomodel->FetchDataToInput(elements,FrictionQEnum);
	iomodel->FetchDataToInput(elements,MaskElementonfloatingiceEnum);
	iomodel->FetchDataToInput(elements,MaskElementonwaterEnum);
	iomodel->FetchDataToInput(elements,MaterialsRheologyBEnum);
	iomodel->FetchDataToInput(elements,MaterialsRheologyNEnum);
	iomodel->FetchDataToInput(elements,VxEnum);
	iomodel->FetchDataToInput(elements,VyEnum);
	iomodel->FetchDataToInput(elements,LoadingforceXEnum);
	iomodel->FetchDataToInput(elements,LoadingforceYEnum);
	if(materials_type==MatdamageiceEnum){
		iomodel->FetchDataToInput(elements,MaterialsRheologyZEnum);
	}
	if(iomodel->dim==3){
		iomodel->FetchDataToInput(elements,MeshElementonbedEnum);
		iomodel->FetchDataToInput(elements,MeshElementonsurfaceEnum);
		iomodel->FetchDataToInput(elements,VzEnum);
		iomodel->FetchDataToInput(elements,SurfaceforcingsMassBalanceEnum);
		iomodel->FetchDataToInput(elements,BasalforcingsMeltingRateEnum);
		iomodel->FetchDataToInput(elements,FlowequationBorderstokesEnum);
		iomodel->FetchDataToInput(elements,LoadingforceZEnum);
	}

	if(control_analysis){
		iomodel->FetchDataToInput(elements,InversionVxObsEnum);
		iomodel->FetchDataToInput(elements,InversionVyObsEnum);
	}

	/*Post-process: */
	elements->InputDuplicate(VxEnum,VxPicardEnum);
	elements->InputDuplicate(VxEnum,InversionVxObsEnum);
	if(dakota_analysis)elements->InputDuplicate(VxEnum,QmuVxEnum);

	#ifdef _HAVE_ANDROID_
	elements->InputDuplicate(FrictionCoefficientEnum,AndroidFrictionCoefficientEnum);
	#endif

	elements->InputDuplicate(VyEnum,VyPicardEnum);
	elements->InputDuplicate(VyEnum,InversionVyObsEnum);
	if(dakota_analysis)elements->InputDuplicate(VyEnum,QmuVyEnum);

	if(iomodel->dim==3){
		elements->InputDuplicate(VzEnum,VzPicardEnum);
		elements->InputDuplicate(VzEnum,InversionVzObsEnum);
		if(dakota_analysis)elements->InputDuplicate(VzEnum,QmuVzEnum);
	}

	/*Free data: */
	iomodel->DeleteData(1,FlowequationElementEquationEnum);
}
