/*
 * CreateNodesDiagnosticHoriz.c:
 */

#include "../../../toolkits/toolkits.h"
#include "../../../classes/classes.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../ModelProcessorx.h"

void	CreateNodesDiagnosticHoriz(Nodes** pnodes, IoModel* iomodel){

	/*Intermediary*/
	bool   ismacayeal,isl1l2,ispattyn,isstokes;
	int    finiteelementssa;

	/*Fetch parameters: */
	iomodel->Constant(&ismacayeal,FlowequationIsmacayealEnum);
	iomodel->Constant(&isl1l2,FlowequationIsl1l2Enum);
	iomodel->Constant(&ispattyn,FlowequationIspattynEnum);
	iomodel->Constant(&isstokes,FlowequationIsstokesEnum);
	iomodel->Constant(&finiteelementssa,FlowequationFeSsaEnum);

	/*Now, is the flag macayaealpattyn on? otherwise, do nothing: */
	if(!ismacayeal & !isl1l2 & !ispattyn & !isstokes) return;

	/*Create nodes: */
	iomodel->FetchData(9,MeshVertexonbedEnum,MeshVertexonsurfaceEnum,FlowequationBordermacayealEnum,FlowequationBorderstokesEnum,
				MaskVertexongroundediceEnum,MaskVertexonfloatingiceEnum,MaskVertexonwaterEnum,FlowequationVertexEquationEnum,DiagnosticReferentialEnum);
	if(finiteelementssa==0){
		CreateNodes(pnodes,iomodel,DiagnosticHorizAnalysisEnum,P1Enum);
	}
	else if(finiteelementssa==1){
		CreateNodes(pnodes,iomodel,DiagnosticHorizAnalysisEnum,P2Enum);
	}
	else{
		_error_("finite element not supported yet");
	}
	iomodel->DeleteData(9,MeshVertexonbedEnum,MeshVertexonsurfaceEnum,FlowequationBordermacayealEnum,FlowequationBorderstokesEnum,
				MaskVertexongroundediceEnum,MaskVertexonfloatingiceEnum,MaskVertexonwaterEnum,FlowequationVertexEquationEnum,DiagnosticReferentialEnum);
}
