/*
 * \file EnumDefinitions.h:
 * \brief: enum functions for our objects
 */

#ifndef _ENUM_DEFINITIONS_
#define _ENUM_DEFINITIONS_

enum definitions{
	/*Model fields {{{*/
	AutodiffIsautodiffEnum, 
	AutodiffNumDependentsEnum,
	AutodiffNumDependentObjectsEnum,
	AutodiffDependentObjectNamesEnum,
	AutodiffDependentObjectTypesEnum,
	AutodiffDependentObjectIndicesEnum,
	AutodiffDependentObjectsEnum,
	AutodiffNumIndependentsEnum,
	AutodiffNumIndependentObjectsEnum,
	AutodiffIndependentObjectNamesEnum,
	AutodiffIndependentObjectTypesEnum,
	AutodiffIndependentObjectsEnum,
	AutodiffJacobianEnum,
	AutodiffXpEnum,
	AutodiffDriverEnum,
	AutodiffFosForwardIndexEnum,
	AutodiffFovForwardIndicesEnum,
	AutodiffFosReverseIndexEnum,
	AutodiffMassFluxSegmentsPresentEnum,
	AutodiffKeepEnum,
	BalancethicknessSpcthicknessEnum,
	BalancethicknessStabilizationEnum,
	BalancethicknessThickeningRateEnum,
	BasalforcingsGeothermalfluxEnum,
	BasalforcingsMeltingRateCorrectionEnum,
	BasalforcingsMeltingRateEnum,
	BathymetryEnum,
	BedEnum,
	ConstantsGEnum,
	ConstantsReferencetemperatureEnum,
	ConstantsYtsEnum,
	DependentObjectEnum,
	DiagnosticAbstolEnum,
	DiagnosticIcefrontEnum,
	DiagnosticIsnewtonEnum,
	DiagnosticMaxiterEnum,
	DiagnosticNumRequestedOutputsEnum,
	DiagnosticPenaltyFactorEnum,
	DiagnosticReferentialEnum,
	DiagnosticReltolEnum,
	DiagnosticRequestedOutputsEnum,
	DiagnosticRestolEnum,
	DiagnosticRiftPenaltyLockEnum,
	DiagnosticRiftPenaltyThresholdEnum,
	DiagnosticShelfDampeningEnum,
	DiagnosticSpcvxEnum,
	DiagnosticSpcvyEnum,
	DiagnosticSpcvzEnum,
	DiagnosticStokesreconditioningEnum,
	DiagnosticVertexPairingEnum,
	DiagnosticViscosityOvershootEnum,
	LoadingforceXEnum,
	LoadingforceYEnum,
	LoadingforceZEnum,
	FlowequationBordermacayealEnum,
	FlowequationBorderpattynEnum,
	FlowequationBorderstokesEnum,
	FlowequationElementEquationEnum,
	FlowequationIshutterEnum,
	FlowequationIsl1l2Enum,
	FlowequationIsmacayealpattynEnum,
	FlowequationIsstokesEnum,
	FlowequationFeStokesEnum,
	FlowequationFeSsaEnum,
	FlowequationVertexEquationEnum,
	FrictionCoefficientEnum,
	FrictionPEnum,
	FrictionQEnum,
	GeometryHydrostaticRatioEnum,
	HydrologyModelEnum,
	HydrologyshreveEnum,
	HydrologyshreveCREnum,
	HydrologyshreveKnEnum,
	HydrologyshreveNEnum,
	HydrologyshrevePEnum,
	HydrologyshreveQEnum,
	HydrologyshreveSpcwatercolumnEnum,
	HydrologyshreveStabilizationEnum,
	HydrologydcEnum,
	SedimentHeadEnum,
	SedimentHeadOldEnum,
	SedimentHeadResidualEnum,
	EplHeadEnum,
	EplHeadOldEnum,
  HydrologydcRelTolEnum,
	HydrologydcSpcsedimentHeadEnum,
	HydrologydcSedimentCompressibilityEnum,
	HydrologydcSedimentPorosityEnum,
	HydrologydcSedimentThicknessEnum,
	HydrologydcSedimentTransmitivityEnum,
	HydrologydcWaterCompressibilityEnum,
	HydrologydcSpceplHeadEnum,
	HydrologydcMaskEplactiveEnum,
	HydrologydcEplCompressibilityEnum,
	HydrologydcEplPorosityEnum,
	HydrologydcEplThicknessEnum,
	HydrologydcEplTransmitivityEnum,
	HydrologydcIsefficientlayerEnum,
	HydrologydcSedimentlimitFlagEnum,
	HydrologydcSedimentlimitEnum,
	HydrologydcTransferFlagEnum,
	HydrologydcLeakageFactorEnum,
	HydrologydcPenaltyFactorEnum,
	HydrologyLayerEnum,
	HydrologySedimentEnum,
	HydrologyEfficientEnum,
	HydrologySedimentKmaxEnum,
	BasisIntegralEnum,
	WaterTransferEnum,
	IndependentObjectEnum,
	InversionControlParametersEnum,
	InversionCostFunctionThresholdEnum,
	InversionCostFunctionsCoefficientsEnum,
	InversionCostFunctionsEnum,
	InversionGradientOnlyEnum,
	InversionGradientScalingEnum,
	InversionIscontrolEnum,
	InversionTaoEnum,
	InversionIncompleteAdjointEnum,
	InversionMaxParametersEnum,
	InversionMaxiterPerStepEnum,
	InversionMinParametersEnum,
	InversionNstepsEnum,
	InversionNumControlParametersEnum,
	InversionNumCostFunctionsEnum,
	InversionStepThresholdEnum,
	InversionThicknessObsEnum,
	InversionVelObsEnum,
	InversionVxObsEnum,
	InversionVyObsEnum,
	InversionVzObsEnum,
	MaskElementonfloatingiceEnum,
	MaskElementongroundediceEnum,
	MaskElementonwaterEnum,
	MaskVertexonfloatingiceEnum,
	MaskVertexongroundediceEnum,
	MaskVertexonwaterEnum,
	IcelevelsetEnum,
	MaterialsBetaEnum,
	MaterialsHeatcapacityEnum,
	MaterialsLatentheatEnum,
	MaterialsMeltingpointEnum,
	MaterialsMixedLayerCapacityEnum,
	MaterialsRheologyBEnum,
	MaterialsRheologyBbarEnum,
	MaterialsRheologyLawEnum,
	MaterialsRheologyNEnum,
	MaterialsRheologyZEnum,
	MaterialsRheologyZbarEnum,
	MaterialsRhoIceEnum,
	MaterialsRhoWaterEnum,
	MaterialsRhoFreshwaterEnum,
	MaterialsMuWaterEnum,
	MaterialsThermalExchangeVelocityEnum,
	MaterialsThermalconductivityEnum,
	MaterialsLithosphereShearModulusEnum,
	MaterialsLithosphereDensityEnum,
	MaterialsMantleShearModulusEnum,
	MaterialsMantleDensityEnum,
	MeshAverageVertexConnectivityEnum,
	MeshDimensionEnum,
	MeshElementonbedEnum,
	MeshElementonsurfaceEnum,
	MeshElements2dEnum,
	MeshElementsEnum,
	MeshLowerelementsEnum,
	MeshNumberofelements2dEnum,
	MeshNumberofelementsEnum,
	MeshNumberoflayersEnum,
	MeshNumberofvertices2dEnum,
	MeshNumberofverticesEnum,
	MeshUpperelementsEnum,
	MeshVertexonbedEnum,
	MeshVertexonsurfaceEnum,
	MeshXEnum,
	MeshYEnum,
	MeshZEnum,
	MiscellaneousNameEnum, //FIXME: only used by qmu, should not be marshalled (already in queueing script)
	PrognosticHydrostaticAdjustmentEnum,
	PrognosticMinThicknessEnum,
	PrognosticPenaltyFactorEnum,
	PrognosticSpcthicknessEnum,
	PrognosticStabilizationEnum,
	PrognosticVertexPairingEnum,
	PrognosticNumRequestedOutputsEnum,
	PrognosticRequestedOutputsEnum,
	QmuIsdakotaEnum,
	MassFluxSegmentsEnum,
	MassFluxSegmentsPresentEnum,
	QmuMassFluxSegmentsPresentEnum,
	QmuNumberofpartitionsEnum,
	QmuNumberofresponsesEnum,
	QmuPartitionEnum,
	QmuResponsedescriptorsEnum,
	QmuVariabledescriptorsEnum,
	QmuMaterialsRheologyBEnum,
	RiftsNumriftsEnum,
	RiftsRiftstructEnum,
	SettingsIoGatherEnum,
	SettingsLowmemEnum,
	SettingsOutputFrequencyEnum,
	SettingsResultsAsPatchesEnum,
	SettingsWaitonlockEnum,
	SurfaceforcingsDelta18oEnum,
	SurfaceforcingsDelta18oSurfaceEnum,
	SurfaceforcingsIsdelta18oEnum,
	SurfaceforcingsPrecipitationsPresentdayEnum,
	SurfaceforcingsTemperaturesPresentdayEnum,
	SurfaceforcingsTemperaturesLgmEnum,
	DebugProfilingEnum,
	ProfilingCurrentMemEnum,
	ProfilingCurrentFlopsEnum,
	ProfilingSolutionTimeEnum,
	MaxIterationConvergenceFlagEnum,
	SteadystateMaxiterEnum,
	SteadystateNumRequestedOutputsEnum,
	SteadystateReltolEnum,
	SteadystateRequestedOutputsEnum,
	SurfaceEnum,
	SurfaceforcingsPrecipitationEnum,
	SurfaceforcingsMassBalanceEnum,
	SurfaceforcingsIspddEnum,
	SurfaceforcingsDesfacEnum,
	SurfaceforcingsS0pEnum,
	SurfaceforcingsIssmbgradientsEnum,
	SurfaceforcingsMonthlytemperaturesEnum,
	SurfaceforcingsHrefEnum,
	SurfaceforcingsSmbrefEnum,
	SurfaceforcingsBPosEnum,
	SurfaceforcingsBNegEnum,
	ThermalMaxiterEnum,
	ThermalPenaltyFactorEnum,
	ThermalPenaltyLockEnum,
	ThermalPenaltyThresholdEnum,
	ThermalSpctemperatureEnum,
	ThermalStabilizationEnum,
	ThermalIsenthalpyEnum,
	GiaMantleViscosityEnum,
	GiaLithosphereThicknessEnum,
	ThicknessEnum,
	TimesteppingStartTimeEnum,
	TimesteppingFinalTimeEnum,
	TimesteppingCflCoefficientEnum,
	TimesteppingTimeAdaptEnum,
	TimesteppingTimeStepEnum,
	TransientIsdiagnosticEnum,
	TransientIsgroundinglineEnum,
	TransientIsprognosticEnum,
	TransientIsthermalEnum,
	TransientIsgiaEnum,
	TransientNumRequestedOutputsEnum,
	TransientRequestedOutputsEnum,
	/*}}}*/
	/*Solutions and Analyses{{{ */
	SolutionTypeEnum,
	AnalysisTypeEnum,
	ConfigurationTypeEnum,
	AdjointBalancethicknessAnalysisEnum,
	AdjointHorizAnalysisEnum,
	AdjointSolutionEnum,
	AnalysisCounterEnum,
	NoneAnalysisEnum,
	DefaultAnalysisEnum,
	BalancethicknessAnalysisEnum,
	BalancethicknessSolutionEnum,
	BalancethicknessSoftAnalysisEnum,
	BalancethicknessSoftSolutionEnum,
	BedSlopeAnalysisEnum,
	BedSlopeSolutionEnum,
	BedSlopeXAnalysisEnum,
	BedSlopeYAnalysisEnum,
	DiagnosticHorizAnalysisEnum,
	DiagnosticHutterAnalysisEnum,
	DiagnosticSolutionEnum,
	DiagnosticVertAnalysisEnum,
	EnthalpyAnalysisEnum,
	EnthalpySolutionEnum,
	FlaimAnalysisEnum,
	FlaimSolutionEnum,
	HydrologyShreveAnalysisEnum,
	HydrologyDCInefficientAnalysisEnum,
	HydrologyDCEfficientAnalysisEnum,
	HydrologySolutionEnum,
	MeltingAnalysisEnum,
	PrognosticAnalysisEnum,
	PrognosticSolutionEnum,
	SteadystateSolutionEnum,
	SurfaceSlopeAnalysisEnum,
	SurfaceSlopeSolutionEnum,
	SurfaceSlopeXAnalysisEnum,
	SurfaceSlopeYAnalysisEnum,
	ThermalAnalysisEnum,
	ThermalSolutionEnum,
	TransientSolutionEnum,
	GiaSolutionEnum,
	GiaAnalysisEnum,
	/*}}}*/
	/*Approximations {{{*/
	ApproximationEnum,
	NoneApproximationEnum,
	HutterApproximationEnum,
	MacAyealApproximationEnum,
	MacAyealPattynApproximationEnum,
	MacAyealStokesApproximationEnum,
	L1L2ApproximationEnum,
	PattynApproximationEnum,
	PattynStokesApproximationEnum,
	StokesApproximationEnum,
	/*}}}*/
	/*Datasets {{{*/
	ConstraintsEnum,
	LoadsEnum,
	MaterialsEnum,
	NodesEnum,
	ContoursEnum,
	ParametersEnum,
	VerticesEnum,
	ResultsEnum,
	/*}}}*/
	/*Objects {{{*/
	GenericParamEnum,
	AdolcParamEnum,
	BoolInputEnum,
	BoolParamEnum,
	ContourEnum,
	ControlInputEnum,
	DatasetInputEnum,
	DofIndexingEnum,
	DoubleInputEnum,
	DataSetParamEnum,
	DoubleMatArrayParamEnum,
	DoubleMatParamEnum,
	DoubleParamEnum,
	DoubleVecParamEnum,
	ElementEnum,
	ElementResultEnum,
	ExternalResultEnum,
	FileParamEnum,
	HookEnum,
	IcefrontEnum,
	InputEnum,
	IntInputEnum,
	IntParamEnum,
	IntVecParamEnum,
	TransientParamEnum,
	IceFrontTypeEnum,
	MacAyeal2dIceFrontEnum,
	MacAyeal3dIceFrontEnum,
	MaticeEnum,
	MatdamageiceEnum,
	MatparEnum,
	NodeEnum,
	NumericalfluxEnum,
	NumericalfluxTypeEnum,
	ParamEnum,
	L1L2IceFrontEnum,
	PattynIceFrontEnum,
	PengridEnum,
	PenpairEnum,
	PentaEnum,
	PentaInputEnum,
	ProfilerEnum,
	MatrixParamEnum,
	NodeSIdEnum,
	VectorParamEnum,
	RiftfrontEnum,
	RiftfrontTypeEnum,
	SegmentEnum,
	SegmentRiftfrontEnum,
	SpcDynamicEnum,
	SpcStaticEnum,
	SpcTransientEnum,
	StokesIceFrontEnum,
	StringArrayParamEnum,
	StringParamEnum,
	TriaEnum,
	TriaInputEnum,
	VertexEnum,
	VertexPIdEnum,
	VertexSIdEnum,
	/*}}}*/
	/*Fill {{{*/
	AirEnum,
	IceEnum,
	MelangeEnum,
	WaterEnum,
	/*}}}*/
	/*Rift state {{{*/
	ClosedEnum,
	FreeEnum,
	OpenEnum,
	/*}}}*/
	/*Inputs {{{*/
	AdjointpEnum,
	AdjointxEnum,
	AdjointyEnum,
	AdjointzEnum,
	BalancethicknessMisfitEnum,
	BedSlopeXEnum,
	BedSlopeYEnum,
	BoundaryEnum,
	ConstantEnum,
	ConvergedEnum,
	FillEnum,
	FractionIncrementEnum,
	FrictionEnum,
	GroundinglineMeltingRateEnum,
	InternalEnum,
	MassFluxEnum,
	MaxPenetrationEnum,
	MeltingOffsetEnum,
	MisfitEnum,
	NumberNodeToElementConnectivityEnum,
	PressureEnum,
	PressurePicardEnum,
	QmuPressureEnum,
	QmuVxEnum,
	QmuVyEnum,
	QmuVzEnum,
	QmuThicknessEnum,
	QmuBedEnum,
	QmuSurfaceEnum,
	QmuMeltingEnum,
	QmuVxMeshEnum,
	QmuVyMeshEnum,
	QmuVzMeshEnum,
	AndroidFrictionCoefficientEnum,
	ResetPenaltiesEnum,
	SegmentOnIceShelfEnum,
	SurfaceAbsVelMisfitEnum,
	SurfaceAreaEnum,
	SurfaceAverageVelMisfitEnum,
	SurfaceLogVelMisfitEnum,
	SurfaceLogVxVyMisfitEnum,
	SurfaceRelVelMisfitEnum,
	SurfaceSlopeXEnum,
	SurfaceSlopeYEnum,
	TemperatureEnum,
	TemperatureOldEnum,
	TemperaturePicardEnum,
	ThicknessAbsMisfitEnum,
	VelEnum,
	VelocityEnum,
	VxAverageEnum,
	VxEnum,
	VxPicardEnum,
	VyAverageEnum,
	VyEnum,
	VyPicardEnum,
	VzEnum,
	VzMacAyealEnum,
	VzPattynEnum,
	VzPicardEnum,
	VzStokesEnum,
	VxMeshEnum,
	VyMeshEnum,
	VzMeshEnum,
	EnthalpyEnum,
	EnthalpyPicardEnum,
	ThicknessAbsGradientEnum,
	ThicknessAlongGradientEnum,
	ThicknessAcrossGradientEnum,
	StepResponsesEnum,
	IntMatParamEnum,
	RheologyBbarAbsGradientEnum,
	DragCoefficientAbsGradientEnum,
	TransientInputEnum,
	WaterfractionEnum,
	WatercolumnEnum,
	BasalFrictionEnum,
	ViscousHeatingEnum,
	QmuTemperatureEnum,
	HydrologyWaterVxEnum,
	HydrologyWaterVyEnum,
	StressTensorEnum,
	StressTensorxxEnum,
	StressTensorxyEnum,
	StressTensorxzEnum,
	StressTensoryyEnum,
	StressTensoryzEnum,
	StressTensorzzEnum,
	GiaCrossSectionShapeEnum,
	GiadWdtEnum,
	GiaWEnum,
	/*}}}*/
	/*Element Interpolations{{{*/
	P0Enum,
	P1Enum,
	P2Enum,
	P1DGEnum,
	P1P2Enum,
	MINIEnum,
	TaylorHoodEnum,
	/*}}}*/
	/*Results{{{*/
	SaveResultsEnum,
	BoolElementResultEnum,
	BoolExternalResultEnum,
	DoubleElementResultEnum,
	DoubleExternalResultEnum,
	DoubleMatExternalResultEnum,
	IntExternalResultEnum,
	JEnum,
	PatchEnum,
	PatchNodesEnum,
	PatchVerticesEnum,
	PentaP1ElementResultEnum,
	StringExternalResultEnum,
	StepEnum,
	TimeEnum,
	TriaP1ElementResultEnum,
	WaterColumnOldEnum,
	/*}}}*/
	/*Responses{{{*/
	MinVelEnum,
	MaxVelEnum,
	MinVxEnum,
	MaxVxEnum,
	MaxAbsVxEnum,
	MinVyEnum,
	MaxVyEnum,
	MaxAbsVyEnum,
	MinVzEnum,
	MaxVzEnum,
	MaxAbsVzEnum,
	IceVolumeEnum,
	TotalSmbEnum,
	/*}}}*/
	/*Relaxation{{{*/
	AbsoluteEnum,
	IncrementalEnum,
	/*}}}*/
	/*Grounding Line{{{*/
	AgressiveMigrationEnum,
	NoneEnum,
	SoftMigrationEnum,
	SubelementMigrationEnum,
	SubelementMigration2Enum,
	GLlevelsetEnum,
	/*}}}*/
	/*Solver{{{*/
	StokesSolverEnum,
	/*}}}*/
	/*Parameters{{{*/
	AdjointEnum,
	ColinearEnum,
	ControlSteadyEnum,
	FsetEnum,
	Gradient1Enum,
	Gradient2Enum,
	Gradient3Enum,
	GradientEnum,
	GroundinglineMigrationEnum,
	GsetEnum,
	IndexEnum,
	IndexedEnum,
	IntersectEnum,
	NodalEnum,
	OldGradientEnum,
	OutputFilePointerEnum,
	OutputFileNameEnum,
	LockFileNameEnum,
	ToolkitsOptionsAnalysesEnum,
	ToolkitsOptionsStringsEnum,
	QmuErrNameEnum,
	QmuInNameEnum,
	QmuOutNameEnum,
	RegularEnum,
	ScaledEnum,
	SeparateEnum,
	SsetEnum,
	VerboseEnum,
	/*}}}*/
	/*Interpolation {{{*/
	TriangleInterpEnum,
	BilinearInterpEnum,
	NearestInterpEnum,
	/*}}}*/
	/*Coordinate Systems{{{*/
	XYEnum,
	XYZPEnum,
	/*}}}*/
	/*Toolkits{{{*/
	DenseEnum,
	MpiDenseEnum,
	SeqEnum,
	MpiEnum,
	/*}}}*/
	/*Options{{{*/
	OptionEnum,
	GenericOptionEnum,
	OptionCellEnum,
	OptionCharEnum,
	OptionStructEnum,
	OptionDoubleEnum,
	OptionLogicalEnum,
	/*}}}*/
	/*Rheology law (move too Material) {{{*/
	PatersonEnum,
	ArrheniusEnum,
	/*}}}*/
	MaximumNumberOfEnums
};

#endif
