#!/bin/bash

#Get number of cpus on current platform
NUMCPUS=$1;

#version of slepc
version=`echo *.tgz | sed 's/\.tgz//g' | sed 's/slepc-//g'`

#Some cleanup
rm -rf install slepc-$version

#Create install directories
mkdir install

#Untar 
tar -zxvf  slepc-$version.tgz

#Move slepc to install directory
mv slepc-$version/* install/
rm -rf slepc-$version

#Make slepc
cd install
./config/configure.py
if [ -z $NUMCPUS ];
then
	make
else
	make -j $NUMCPUS
fi
