#include "../../../toolkits/toolkits.h"
#include "../../../classes/classes.h"
#include "../../../shared/shared.h"
#include "../ModelProcessorx.h"
#include "../../IoModelToConstraintsx/IoModelToConstraintsx.h"

void	CreateConstraintsPrognostic(Constraints** pconstraints, IoModel* iomodel){

	/*Fetch parameters: */
	int stabilization;
	iomodel->Constant(&stabilization,PrognosticStabilizationEnum);

	/*Recover pointer: */
	Constraints* constraints=*pconstraints;

	/*Do not add constraints in DG, they are weakly imposed*/
	if(stabilization!=3){
		IoModelToConstraintsx(constraints,iomodel,PrognosticSpcthicknessEnum,PrognosticAnalysisEnum,P1Enum);
	}

	/*Assign output pointer: */
	*pconstraints=constraints;
}
