/*
 * CreateConstraintsHydrologyDCInefficient.c:
 */

#include "../../../toolkits/toolkits.h"
#include "../../../classes/classes.h"
#include "../../../shared/shared.h"
#include "../ModelProcessorx.h"
#include "../../IoModelToConstraintsx/IoModelToConstraintsx.h"

void	CreateConstraintsHydrologyDCInefficient(Constraints** pconstraints, IoModel* iomodel){

	/*Recover pointer: */
	Constraints* constraints=*pconstraints;

	/*retrieve some parameters: */
	int hydrology_model;
	iomodel->Constant(&hydrology_model,HydrologyModelEnum);
	if(hydrology_model!=HydrologydcEnum) return;

	IoModelToConstraintsx(constraints,iomodel,HydrologydcSpcsedimentHeadEnum,HydrologyDCInefficientAnalysisEnum,P1Enum);

	/*Assign output pointer: */
	*pconstraints=constraints;
}
