/*
 * CreateNodesPrognostic.c:
 */

#include "../../../toolkits/toolkits.h"
#include "../../../classes/classes.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../ModelProcessorx.h"

void	CreateNodesPrognostic(Nodes** pnodes, IoModel* iomodel){

	/*Fetch parameters: */
	int  stabilization;
	iomodel->Constant(&stabilization,PrognosticStabilizationEnum);

	/*Check in 3d*/
	if(stabilization==3 && iomodel->dim==3) _error_("DG 3d not implemented yet");

	/*Create Nodes either DG or CG depending on stabilization*/
	iomodel->FetchData(6,MeshVertexonbedEnum,MeshVertexonsurfaceEnum,MaskVertexongroundediceEnum,MaskVertexonfloatingiceEnum,FlowequationVertexEquationEnum,MaskVertexonwaterEnum);
	if(stabilization!=3){
		CreateNodes(pnodes,iomodel,PrognosticAnalysisEnum,P1Enum);
	}
	else{
		CreateNodes(pnodes,iomodel,PrognosticAnalysisEnum,P1DGEnum);
	}
	iomodel->DeleteData(6,MeshVertexonbedEnum,MeshVertexonsurfaceEnum,MaskVertexongroundediceEnum,MaskVertexonfloatingiceEnum,FlowequationVertexEquationEnum,MaskVertexonwaterEnum);
}
