/*
 * CreateNodesDiagnosticHutter.c:
 */

#include "../../../toolkits/toolkits.h"
#include "../../../classes/classes.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../ModelProcessorx.h"

void	CreateNodesDiagnosticHutter(Nodes** pnodes, IoModel* iomodel){

	/*Fetch parameters: */
	bool ishutter;
	iomodel->Constant(&ishutter,FlowequationIshutterEnum);

	/*Now, is the flag ishutter on? otherwise, do nothing: */
	if(!ishutter) return;

	iomodel->FetchData(6,MeshVertexonbedEnum,MeshVertexonsurfaceEnum,MaskVertexongroundediceEnum,MaskVertexonfloatingiceEnum,FlowequationVertexEquationEnum,MaskVertexonwaterEnum);
	CreateNodes(pnodes,iomodel,DiagnosticHutterAnalysisEnum,P1Enum);
	iomodel->DeleteData(6,MeshVertexonbedEnum,MeshVertexonsurfaceEnum,MaskVertexongroundediceEnum,MaskVertexonfloatingiceEnum,FlowequationVertexEquationEnum,MaskVertexonwaterEnum);
}
