/*
 * CreateNodesDiagnosticHoriz.c:
 */

#include "../../../toolkits/toolkits.h"
#include "../../../classes/classes.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../ModelProcessorx.h"

void	CreateNodesDiagnosticHoriz(Nodes** pnodes, IoModel* iomodel){

	/*Intermediary*/
	bool   isstokes,isl1l2,ismacayealpattyn;
	int    finiteelementssa;

	/*Fetch parameters: */
	iomodel->Constant(&isstokes,FlowequationIsstokesEnum);
	iomodel->Constant(&isl1l2,FlowequationIsl1l2Enum);
	iomodel->Constant(&ismacayealpattyn,FlowequationIsmacayealpattynEnum);
	iomodel->Constant(&finiteelementssa,FlowequationFeSsaEnum);

	/*Now, is the flag macayaealpattyn on? otherwise, do nothing: */
	if(!ismacayealpattyn & !isstokes & !isl1l2) return;

	/*Create nodes: */
	iomodel->FetchData(9,MeshVertexonbedEnum,MeshVertexonsurfaceEnum,FlowequationBordermacayealEnum,FlowequationBorderstokesEnum,
				MaskVertexongroundediceEnum,MaskVertexonfloatingiceEnum,MaskVertexonwaterEnum,FlowequationVertexEquationEnum,DiagnosticReferentialEnum);
	if(finiteelementssa==0){
		CreateNodes(pnodes,iomodel,DiagnosticHorizAnalysisEnum,P1Enum);
	}
	else if(finiteelementssa==1){
		CreateNodes(pnodes,iomodel,DiagnosticHorizAnalysisEnum,P2Enum);
	}
	else{
		_error_("finite element not supported yet");
	}
	iomodel->DeleteData(9,MeshVertexonbedEnum,MeshVertexonsurfaceEnum,FlowequationBordermacayealEnum,FlowequationBorderstokesEnum,
				MaskVertexongroundediceEnum,MaskVertexonfloatingiceEnum,MaskVertexonwaterEnum,FlowequationVertexEquationEnum,DiagnosticReferentialEnum);
}
