/*!\file:  EdgesPartitioning.cpp
 * \brief: partition elements and nodes and vertices
 */ 

#include <string.h>
#include "../../classes/classes.h"
#include "../../shared/shared.h"
#include "./ModelProcessorx.h"

void EdgesPartitioning(bool** pmy_edges,IoModel* iomodel){

	/*Intermediaries*/
	int  el1,el2;
	bool my_edge;

	/*Get edges and elements*/
	CreateEdges(iomodel);

	/*output: */
	bool* my_edges=xNew<bool>(iomodel->numberofedges);

	for(int i=0;i<iomodel->numberofedges;i++){

		/*Get left and right elements*/
		el1=iomodel->edges[4*i+2]-1; //edges are [node1 node2 elem1 elem2]
		el2=iomodel->edges[4*i+3]-1; //edges are [node1 node2 elem1 elem2]

		/*Check whether we should include this edge (el2 is -2 for boundary edges)*/
		my_edge = iomodel->my_elements[el1];
		if(!my_edge && el2>=0){
			my_edge = iomodel->my_elements[el2];
		}

		my_edges[i] = my_edge;
	}

	/*Free data and assign output pointers */
	*pmy_edges=my_edges;
}
