/*
 * CreateNodesDiagnosticHoriz.c:
 */

#include "../../../toolkits/toolkits.h"
#include "../../../classes/classes.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../ModelProcessorx.h"

void	CreateNodesDiagnosticHoriz(Nodes** pnodes, IoModel* iomodel){

	/*Intermediary*/
	bool   isstokes,isl1l2,ismacayealpattyn;
	int    finiteelementssa;

	/*Fetch parameters: */
	iomodel->Constant(&isstokes,FlowequationIsstokesEnum);
	iomodel->Constant(&isl1l2,FlowequationIsl1l2Enum);
	iomodel->Constant(&ismacayealpattyn,FlowequationIsmacayealpattynEnum);
	iomodel->Constant(&finiteelementssa,FlowequationFeSsaEnum);

	/*Recover pointer: */
	Nodes* nodes=*pnodes;

	/*First create nodes*/
	if(!nodes) nodes = new Nodes();

	/*Now, is the flag macayaealpattyn on? otherwise, do nothing: */
	if(!ismacayealpattyn & !isstokes & !isl1l2){
		*pnodes=nodes;
		return;
	}

	/*Create nodes: */
	iomodel->FetchData(9,MeshVertexonbedEnum,MeshVertexonsurfaceEnum,FlowequationBordermacayealEnum,FlowequationBorderstokesEnum,
				MaskVertexongroundediceEnum,MaskVertexonfloatingiceEnum,MaskVertexonwaterEnum,FlowequationVertexEquationEnum,DiagnosticReferentialEnum);

	for(int i=0;i<iomodel->numberofvertices;i++){

		if(iomodel->my_vertices[i]){

			/*Add node to nodes dataset: */
			nodes->AddObject(new Node(iomodel->nodecounter+i+1,i,i+1,i,iomodel,DiagnosticHorizAnalysisEnum));
		}
	}

	if(finiteelementssa==1){

		/*Quadratic element*/
		bool *my_edges = NULL;
		EdgesPartitioning(&my_edges,iomodel);
		CreateElementToEdgeConnectivity(iomodel);

		for(int i=0;i<iomodel->numberofedges;i++){
			if(my_edges[i]){
				nodes->AddObject(new Node(iomodel->nodecounter+iomodel->numberofvertices+i+1,iomodel->numberofvertices+i,0,0,iomodel,DiagnosticHorizAnalysisEnum));
			}
		}
		/*Clean up*/
		xDelete<bool>(my_edges);
	}

	/*Clean fetched data: */
	iomodel->DeleteData(9,MeshVertexonbedEnum,MeshVertexonsurfaceEnum,FlowequationBordermacayealEnum,FlowequationBorderstokesEnum,
				MaskVertexongroundediceEnum,MaskVertexonfloatingiceEnum,MaskVertexonwaterEnum,FlowequationVertexEquationEnum,DiagnosticReferentialEnum);

	/*Assign output pointer: */
	*pnodes=nodes;
}
