/*
 * CreateNodesHydrologyDCInefficient.c:
 */

#include "../../../toolkits/toolkits.h"
#include "../../../classes/classes.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../ModelProcessorx.h"

void	CreateNodesHydrologyDCInefficient(Nodes** pnodes, IoModel* iomodel){

	/*Intermediary*/
	int  hydrology_model;

	/*Fetch parameters: */
	iomodel->Constant(&hydrology_model,HydrologyModelEnum);

	/*Recover pointer: */
	Nodes* nodes=*pnodes;

	/*Create nodes if they do not exist yet*/
	if(!nodes) nodes = new Nodes();

	/*Now, do we really want DC?*/
	if(hydrology_model!=HydrologydcEnum){
		*pnodes=nodes;
		return;
	}

	/*Create nodes and vertices: */
	iomodel->FetchData(6,MeshVertexonbedEnum,MeshVertexonsurfaceEnum,MaskVertexongroundediceEnum,MaskVertexonfloatingiceEnum,FlowequationVertexEquationEnum,MaskVertexonwaterEnum);
	for(int i=0;i<iomodel->numberofvertices;i++){

		if(iomodel->my_vertices[i]){
			/*Add node to nodes dataset: */
			nodes->AddObject(new Node(iomodel->nodecounter+i+1,i,i+1,i,iomodel,HydrologyDCInefficientAnalysisEnum));

		}
	}
	iomodel->DeleteData(6,MeshVertexonbedEnum,MeshVertexonsurfaceEnum,MaskVertexongroundediceEnum,MaskVertexonfloatingiceEnum,FlowequationVertexEquationEnum,MaskVertexonwaterEnum);

	/*Assign output pointer: */
	*pnodes=nodes;
}
